/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cloud.profiler.commons.pap.v1.converters;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.huawei.cloud.profiler.commons.pap.v1.converters.DynamicMessageAnalyzerHelper;
import com.huawei.cloud.profiler.commons.pap.v1.converters.PDataConverter;
import com.huawei.cloud.profiler.commons.pap.v1.converters.ProtobufException;
import com.huawei.cloud.profiler.pap.v1.Metadata;
import com.huawei.cloud.profiler.pap.v1.PData;
import java.io.IOException;

public abstract class AbstractPDataConverter
implements PDataConverter {
    private static final int RECURSION_LIMIT = 256;
    private final DynamicMessageAnalyzerHelper analyzerHelper = new DynamicMessageAnalyzerHelper(PData.class, (Message)PData.getDefaultInstance().getPayload());

    @Override
    public abstract PData read(byte[] var1);

    protected final PData processInputStream(CodedInputStream input) throws InvalidProtocolBufferException {
        PData.Builder builder = PData.newBuilder();
        try {
            input.setRecursionLimit(256);
            builder.mergeFrom(input);
            input.checkLastTagWas(0);
            return builder.build();
        }
        catch (IOException ex) {
            throw new ProtobufException("Failed to read protobuf message", ex);
        }
    }

    @Override
    public final PData reconstruct(Metadata metadata, Message innerMsg) {
        Descriptors.FieldDescriptor dynaFieldDesc = this.analyzerHelper.retrieveDynamicFieldDescriptor(innerMsg);
        PData.Payload payload = PData.Payload.newBuilder().setField(dynaFieldDesc, innerMsg).build();
        return PData.newBuilder().setMetadata(metadata).setPayload(payload).build();
    }

    @Override
    public final Message extractInnerMessage(PData data) {
        Descriptors.OneofDescriptor desc = (Descriptors.OneofDescriptor)data.getPayload().getDescriptorForType().getOneofs().get(0);
        Descriptors.FieldDescriptor fieldDesc = data.getPayload().getOneofFieldDescriptor(desc);
        return (Message)data.getPayload().getField(fieldDesc);
    }

    @Override
    public final <T extends Message> T extractInnerMessage(PData data, Class<T> innerMsgType) {
        Message extracted = this.extractInnerMessage(data);
        return (T)((Message)innerMsgType.cast(extracted));
    }
}

