/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.client.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoapClientAggregator
extends MultiPrimaryKeyAggregator<CoapStats> {
    private static final String URL = "url";
    private static final String REQUEST_TYPE = "requestType";
    private static final String ENV_ID = "envId";
    private static final String METHOD = "method";

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected != null && !collected.isEmpty()) {
            HashMap<String, List<MonitorDataRow>> result = new HashMap<String, List<MonitorDataRow>>();
            ArrayList<MonitorDataRow> clusterRows = new ArrayList<MonitorDataRow>();
            HashMap<String, MonitorDataRow> conMap = new HashMap<String, MonitorDataRow>();
            for (MonitorDataRow detailRow : collected) {
                MonitorDataRow row;
                String requestType = (String)detailRow.get((Object)REQUEST_TYPE);
                if (!"CON".equals(requestType)) continue;
                String envId = (String)detailRow.get((Object)ENV_ID);
                if (envId == null) {
                    envId = "unknown";
                }
                if ((row = (MonitorDataRow)conMap.get(envId)) == null) {
                    row = new MonitorDataRow();
                    row.put((Object)"clusterId", (Object)envId);
                    conMap.put(envId, row);
                    clusterRows.add(row);
                }
                this.setNewCount(row, detailRow, "invokeCount");
                this.setNewCount(row, detailRow, "totalTime");
                this.setNewCount(row, detailRow, "errorCount");
            }
            result.put("cluster_con", clusterRows);
            return result;
        }
        return null;
    }

    private void setNewCount(MonitorDataRow row, MonitorDataRow detailRow, String key) {
        Long oldCount = (Long)row.get((Object)key);
        Long addCount = (Long)detailRow.get((Object)key);
        if (oldCount == null) {
            oldCount = 0L;
        }
        if (addCount == null) {
            addCount = 0L;
        }
        row.put((Object)key, (Object)(oldCount + addCount));
    }

    public Map<String, Object> onStart(String requestUri, String requestType, String methodType) {
        if (!this.isEnable) {
            return null;
        }
        HashMap<String, Object> collectorContext = new HashMap<String, Object>();
        CoapStats stats = (CoapStats)this.getValue(new String[]{requestUri, requestType, methodType});
        if (stats != null) {
            if ("CON".equals(requestType)) {
                stats.setConType(true);
            }
            long startTime = stats.onStart();
            collectorContext.put("startTime", startTime);
            collectorContext.put("statsBase", (Object)stats);
            return collectorContext;
        }
        return null;
    }

    public void conRequestOnResponseClose(boolean isSuccess, CoapStats stats, Long startTime, String envId, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null && startTime != null) {
            Long timeUsed = System.nanoTime() - startTime;
            if (stats.onFinally(timeUsed)) {
                stats.setSlowTraceId(traceId);
            }
            if (stats.getEnvId() == null && envId != null) {
                stats.setEnvId(envId);
            }
            TransactionCollector.collect((long)timeUsed, (!isSuccess ? 1 : 0) != 0, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)envId, (List)TransactionCollector.getTxName(), (String)"CoapClient");
        }
    }

    public void nonRequestSent(CoapStats stats, Long startTime) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null & startTime != null) {
            Long timeUsed = System.nanoTime() - startTime;
            stats.onFinally(timeUsed);
        }
    }

    public void onError(CoapStats stats, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null) {
            stats.incrementErrorCount();
            stats.setErrorTraceId(traceId);
        }
    }

    public String getName() {
        return "detail";
    }

    protected Class<CoapStats> getValueType() {
        return CoapStats.class;
    }

    protected int primaryKeyLength() {
        return 3;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(URL, REQUEST_TYPE, METHOD);
    }
}

