/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.server.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultStats;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.core.coap.CoAP;

public class CoapClusterStats
extends DefaultStats {
    private static final String CLIENT_ERROR_COUNT = "clientErrorCount";
    private static final String SERVER_ERROR_COUNT = "serverErrorCount";
    protected final AtomicLong clientErrorCount = new AtomicLong(0L);
    protected final AtomicLong serverErrorCount = new AtomicLong(0L);
    protected volatile long clientErrorCountOld;
    protected volatile long serverErrorCountOld;

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        if (row != null) {
            row.put((Object)CLIENT_ERROR_COUNT, (Object)this.clientErrorCount);
            row.put((Object)SERVER_ERROR_COUNT, (Object)this.serverErrorCount);
        }
        return row;
    }

    public MonitorDataRow harvest() {
        MonitorDataRow row = super.harvest();
        if (row != null) {
            long clientErrorCountNew = this.clientErrorCount.get();
            long serverErrorCountNew = this.serverErrorCount.get();
            row.put((Object)CLIENT_ERROR_COUNT, (Object)(clientErrorCountNew - this.clientErrorCountOld));
            row.put((Object)SERVER_ERROR_COUNT, (Object)(serverErrorCountNew - this.serverErrorCountOld));
            this.clientErrorCountOld = clientErrorCountNew;
            this.serverErrorCountOld = serverErrorCountNew;
        }
        return row;
    }

    public void onError(CoAP.ResponseCode code) {
        if (CoAP.ResponseCode.isServerError((CoAP.ResponseCode)code)) {
            this.serverErrorCount.incrementAndGet();
        } else {
            this.clientErrorCount.incrementAndGet();
        }
        this.onError();
    }
}

