/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.sql.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ConnectionStats
extends DefaultSectionStats {
    private volatile int createdCountOld;
    private volatile int destroyedCountOld;
    private volatile int updatedRowCountOld;
    private volatile int readRowCountOld;
    private AtomicInteger currentCount = new AtomicInteger(0);
    private AtomicInteger createdCount = new AtomicInteger(0);
    private AtomicInteger destroyedCount = new AtomicInteger(0);
    private AtomicReference<String> slowestSql = new AtomicReference();
    private AtomicInteger updatedRowCount = new AtomicInteger(0);
    private AtomicInteger readRowCount = new AtomicInteger(0);

    public void onConnectionCreated() {
        this.currentCount.incrementAndGet();
        this.createdCount.incrementAndGet();
    }

    public long onStart() {
        long t = System.nanoTime();
        return t;
    }

    public void onConnectionDestroyed() {
        this.currentCount.decrementAndGet();
        this.destroyedCount.incrementAndGet();
    }

    public void onError(String sql) {
        this.errorCount.incrementAndGet();
    }

    public void onFinally(long timeUsed, String sql, int updatedCount, int readRowCount) {
        boolean success = super.onFinallyNoRunningCount(timeUsed);
        if (success) {
            this.slowestSql.set(sql);
        }
        this.updatedRowCount.addAndGet(updatedCount);
        this.readRowCount.addAndGet(readRowCount);
    }

    public MonitorDataRow harvest(int[] newRanges) {
        int createdCountNew = this.createdCount.get();
        int destroyedCountNew = this.destroyedCount.get();
        int updatedRowCountNew = this.updatedRowCount.get();
        int readRowCountNew = this.readRowCount.get();
        MonitorDataRow csv = super.harvest(newRanges);
        if (csv != null) {
            csv.put((Object)"currentCount", (Object)this.currentCount.get());
            csv.put((Object)"createdCount", (Object)(createdCountNew - this.createdCountOld));
            csv.put((Object)"destroyedCount", (Object)(destroyedCountNew - this.destroyedCountOld));
            csv.put((Object)"updatedRowCount", (Object)(updatedRowCountNew - this.updatedRowCountOld));
            csv.put((Object)"readRowCount", (Object)(readRowCountNew - this.readRowCountOld));
            csv.put((Object)"slowestSql", this.slowestSql.getAndSet(null));
        }
        this.createdCountOld = createdCountNew;
        this.destroyedCountOld = destroyedCountNew;
        this.updatedRowCountOld = updatedRowCountNew;
        this.readRowCountOld = readRowCountNew;
        return csv;
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow csv = super.getStatus();
        csv.put((Object)"currentCount", (Object)this.currentCount.get());
        csv.put((Object)"createdCount", (Object)this.createdCount.get());
        csv.put((Object)"destroyedCount", (Object)this.destroyedCount.get());
        csv.put((Object)"updatedRowCount", (Object)this.updatedRowCount.get());
        csv.put((Object)"readRowCount", (Object)this.readRowCount.get());
        csv.put((Object)"slowestSql", (Object)this.slowestSql.get());
        return csv;
    }
}

