/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.config;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.bootstrap.utils.ParamCheckUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class AgentConfigManager {
    private static final int DEFAULT_BODY_LENGTH = 9999;
    private static final int DEFAULT_SPRING_BEAN_NUMBER = 2000;
    public static final String MASTER_ADDRESS = "master.address";
    public static final String MASTER_ADDRESS_SYS_KEY = "masterAddress";
    public static final String MASTER_ADDRESS_ENV_KEY = "APM_MASTER_ADDRESS";
    public static final String TX_ENABLE = "transaction.enable";
    public static final String ACCESS_ADDRESS_SYS_KEY = "accessAddress";
    public static final String ACCESS_ADDRESS_ENV_KEY = "APM_ACCESS_ADDRESS";
    public static final String ACCESS_ADDRESS = "access.address";
    public static final String SECURE_CHANNEL = "access.secure.channel";
    public static final String LOG_LEVEL = "log.level";
    public static final String EVENT_THREAD_COUNT = "event.thread.count";
    public static final String MASTER_ACCESS_KEY = "access.key";
    public static final String MASTER_ACCESS_KEY_SYS_KEY = "accessKey";
    public static final String MASTER_ACCESS_KEY_ENV_KEY = "APM_ACCESS_KEY";
    public static final String MASTER_SECRET_KEY = "secret.key";
    public static final String MASTER_SECRET_KEY_SYS_KEY = "secretKey";
    public static final String MASTER_SECRET_KEY_ENV_KEY = "APM_SECRET_KEY";
    public static final String TRANSFORM_SPRING_BEAN_SYS = "transformSpringBean";
    public static final String TRANSFORM_SPRING_BEAN_ENV = "APM_TRANSFORM_SPRING_BEAN";
    public static final String TRANSFORM_SPRING_BEAN_CLOSE_VALUE = "false";
    public static final String FILTER_LOG_MESSAGE = "filter.log.message";
    public static final String RUN_ENVIRONMENT = "run_environment";
    public static final String PROXY = "apm.proxy";
    public static final String SYS_PROXY_LIST = "apmProxy";
    public static final String ENV_PROXY_LIST = "APM_PROXY_LIST";
    public static final String SPRING_BEAN_INCLUDE_PATH_CONFIG = "apm.spring.bean.include.path";
    public static final String SPRING_BEAN_INCLUDE_PATH_SYS = "apmSpringBeanIncludePath";
    public static final String SPRING_BEAN_INCLUDE_PATH_ENV = "APM_SPRING_BEAN_INCLUDE_PATH";
    public static final String SPRING_BEAN_EXCLUDE_PATH_CONFIG = "apm.spring.bean.exclude.path";
    public static final String SPRING_BEAN_EXCLUDE_PATH_SYS = "apmSpringBeanExcludePath";
    public static final String SPRING_BEAN_EXCLUDE_PATH_ENV = "APM_SPRING_BEAN_EXCLUDE_PATH";
    public static final String SPRING_BEAN_MAX_NUMBER_CONFIG = "apm.spring.bean.max.number";
    public static final String SPRING_BEAN_MAX_NUMBER_ENV = "APM_SPRING_BEAN_MAX_NUMBER";
    public static final String COLLECT_BODY = "collect.body";
    public static final String COLLECT_METHOD_BODY = "collect.method.body";
    public static final String COLLECT_HTTPCLIENT_BODY = "collect.httpclient.body";
    public static final String COLLECT_SQL_RESULT = "collect.sql.result";
    public static final String COLLECT_BODY_LENGTH = "collect.body.length";
    public static final String DECRYPT_CLASS_NAME = "decrypt.className";
    public static final String DECRYPT_METHOD_NAME = "decrypt.methodName";
    public static final String TRANSFORM_SPRING_BEAN = "transform.spring.bean";
    private static final String DECRYPT_PACKAGE = "ext";
    public static final int SPRING_BEAN_PATH_MAX_LENGTH = 20;
    public static final String SYS_OTEL_EXPORTER_TRACES_ENDPOINT = "otelExporterTracesEndpoint";
    public static final String ENV_OTEL_EXPORTER_TRACES_ENDPOINT = "OTEL_EXPORTER_OTLP_TRACES_ENDPOINT";
    public static final String CONFIG_OTEL_EXPORTER_TRACES_ENDPOINT = "otel.exporter.otlp.traces.endpoint";
    public static final String SYS_OTEL_EXPORTER_HEADERS = "otelExporterHeaders";
    public static final String ENV_OTEL_EXPORTER_TRACES_HEADERS = "OTEL_EXPORTER_OTLP_TRACES_HEADERS";
    public static final String CONFIG_OTEL_EXPORTER_HEADERS = "otel.exporter.otlp.headers";
    public static final String SYS_OTEL_SERVICE_NAME = "otelServiceName";
    public static final String ENV_OTEL_SERVICE_NAME = "OTEL_SERVICE_NAME";
    public static final String CONFIG_OTEL_SERVICE_NAME = "otel.service.name";
    public static final String CONFIG_APM_OTPL_ENABLE = "apm.otel.enable";
    public static final String ENV_APM_OTPL_ENABLE = "APM_OTEL_ENABLE";
    public static final String SYS_APM_OTPL_ENABLE = "apmOtelEnable";
    private static boolean apmOtelEnabled = false;
    private static boolean isClosed = false;
    private static final String HTTP_CLIENT_TO = "http.client.to.ms";
    private static final String MAX_EVENTS_IN_PROCESS = "max.events.in.process";
    private static final String MAX_SAMPLING_THRESHOLD_PERSECOND = "max.sampling.threshold.persecond";
    private static int maxEventsInProcess = 1000;
    private static String defaultMaxEventsInProcess = "999999999";
    private static final String OFF_HEAP_FILE_DIR = "offheap.file.dir";
    private static final String OFF_HEAP_FILE_FIRST = "offheap.file.first";
    private static final String OFF_HEAP_FILE_ENABLE = "offheap.file.enable";
    private static final String OFF_HEAP_FILES_AMOUNT = "offheap.files.amount";
    private static final String TRACE_SEND_LOG = "trace.send.log";
    private static final String OFF_HEAP_READ_BATCH_SIZE = "offheap.read.batch.size";
    private static String offHeapFileDir = "/tmp/apm/instances";
    private static boolean offHeapFileFirst = false;
    private static boolean offHeapFileEnable = false;
    private static boolean traceSendLog = false;
    private static int offHeapFilesAmount = 10;
    private static int offHeapReadBatchSize = 15;
    private static int httpClientTo = 3000;
    private static int maxSamplingThresholdPerSecond = 100;
    private static String masterAddress = "";
    private static String accessAddress = "";
    private static boolean isServerLess = false;
    private static boolean isDrap = false;
    private static String logLevel = "info";
    private static int eventThreadCount = 3;
    private static boolean txEnable = true;
    private static Boolean secureChannel = null;
    private static String[] proxyList = new String[0];
    private static String[] springBeanIncludePathList = new String[0];
    private static String[] springBeanExcludePathList = new String[0];
    private static String masterAuthAk;
    private static String masterAuthSk;
    private static boolean collectBody;
    private static boolean collectSQLResult;
    private static boolean collectMethodBody;
    private static boolean collectHttpClientBody;
    private static boolean transformSpringBean;
    private static boolean isKunPeng;
    private static int collectBodyLength;
    private static int springBeanMaxNumber;
    private static String otelEndPoint;
    private static Map<String, String> otelHeaders;
    private static String otelServiceName;
    private static final Logger LOGGER;
    private static boolean filterLogMessage;

    public static void init(String configPath) {
        String isSecureChannel;
        String txEnable;
        LOGGER.log(Level.INFO, "start init config file " + configPath);
        Properties properties = FileUtils.readFilePropertyByPath(configPath + File.separator + "apm.config");
        AgentConfigManager.parseMasterAuthAk(properties);
        AgentConfigManager.parseMasterAuthSk(properties);
        AgentConfigManager.parseProxyList(properties);
        AgentConfigManager.parseSpringBeanIncludePath(properties);
        AgentConfigManager.parseSpringBeanExcludePath(properties);
        AgentConfigManager.parseSpringBeanMaxNumber(properties);
        AgentConfigManager.parseAccessAddress(properties);
        AgentConfigManager.parseTransformSpringBean(properties);
        AgentConfigManager.initOffHeapParams(properties);
        AgentConfigManager.parseOtelEndpoint(properties);
        AgentConfigManager.parseOtelAuthentication(properties);
        AgentConfigManager.parseOtelServiceName(properties);
        AgentConfigManager.parseOtelEnable(properties);
        AgentConfigManager.getDecryptSK(configPath, properties);
        AgentConfigManager.parseMasterAddress(properties);
        AgentConfigManager.setLogLevel(properties.getProperty(LOG_LEVEL));
        AgentConfigManager.setEventThreadCount(StringUtils.string2Int(properties.getProperty(EVENT_THREAD_COUNT), 3));
        String filterLogMessage = properties.getProperty(FILTER_LOG_MESSAGE);
        if ("true".equals(filterLogMessage)) {
            AgentConfigManager.filterLogMessage = true;
        }
        if ("true".equals(txEnable = properties.getProperty(TX_ENABLE))) {
            AgentConfigManager.txEnable = true;
        }
        if ("true".equals(isSecureChannel = properties.getProperty(SECURE_CHANNEL))) {
            secureChannel = true;
        } else if (TRANSFORM_SPRING_BEAN_CLOSE_VALUE.equals(isSecureChannel)) {
            secureChannel = false;
        }
        AgentConfigManager.initFullSamplingConfig(properties);
        AgentConfigManager.checkAgentConfig();
        AgentConfigManager.getBodyConfig(properties);
        if (System.getenv("CAS_LOGICCELL_NAME") != null) {
            AgentConfigManager.setDrap(true);
            LogFactory.getLogger().log(Level.WARNING, "DRAP IS TRUE");
        }
    }

    private static void initFullSamplingConfig(Properties properties) {
        LOGGER.log(Level.INFO, "init full sampling config");
        String httpClientTOStr = properties.getProperty(HTTP_CLIENT_TO);
        if (httpClientTOStr != null) {
            httpClientTo = Integer.parseInt(httpClientTOStr);
        }
        maxEventsInProcess = Integer.parseInt(Optional.ofNullable(properties.getProperty(MAX_EVENTS_IN_PROCESS)).orElse(defaultMaxEventsInProcess));
        LOGGER.log(Level.INFO, "init full sampling done httpClientTo [" + httpClientTo + "] maxEventsInProcess [" + maxEventsInProcess + "] maxSamplingThresholdPerSecond [" + maxSamplingThresholdPerSecond + "]");
    }

    public static int getMaxEventsInProcess() {
        return maxEventsInProcess;
    }

    private static void initOffHeapParams(Properties properties) {
        offHeapFileDir = properties.getProperty(OFF_HEAP_FILE_DIR) != null ? properties.getProperty(OFF_HEAP_FILE_DIR) : "/tmp/apm/instances";
        offHeapFileFirst = "true".equals(Optional.ofNullable(properties.getProperty(OFF_HEAP_FILE_FIRST)).orElse(TRANSFORM_SPRING_BEAN_CLOSE_VALUE));
        offHeapFileEnable = "true".equals(Optional.ofNullable(properties.getProperty(OFF_HEAP_FILE_ENABLE)).orElse(TRANSFORM_SPRING_BEAN_CLOSE_VALUE));
        traceSendLog = "true".equals(Optional.ofNullable(properties.getProperty(TRACE_SEND_LOG)).orElse(TRANSFORM_SPRING_BEAN_CLOSE_VALUE));
        offHeapFilesAmount = properties.getProperty(OFF_HEAP_FILES_AMOUNT) != null ? Integer.parseInt(properties.getProperty(OFF_HEAP_FILES_AMOUNT)) : 10;
        offHeapReadBatchSize = properties.getProperty(OFF_HEAP_READ_BATCH_SIZE) != null ? Integer.parseInt(properties.getProperty(OFF_HEAP_READ_BATCH_SIZE)) : 15;
        LOGGER.log(Level.INFO, "initOffHeapParams done  offHeapFileDir [" + offHeapFileDir + "] offHeapFileFirst [" + offHeapFileFirst + "] offHeapFileEnable [" + offHeapFileEnable + "] offHeapFilesAmount [" + offHeapFilesAmount + "] offHeapReadBatchSize [" + offHeapReadBatchSize + "]");
    }

    public static boolean isOffHeapFileFirst() {
        return offHeapFileFirst;
    }

    public static boolean isOffHeapFileEnable() {
        return offHeapFileEnable;
    }

    public static boolean isTraceSendLog() {
        return traceSendLog;
    }

    public static void setMaxSamplingThresholdPerSecond(int maxSamplingThresholdPerSecondVar) {
        LOGGER.log(Level.INFO, "setMaxSamplingThresholdPerSecond [" + maxSamplingThresholdPerSecondVar + "]");
        maxSamplingThresholdPerSecond = maxSamplingThresholdPerSecondVar;
    }

    public static int getMaxSamplingThresholdPerSecond() {
        return maxSamplingThresholdPerSecond;
    }

    private static void parseMasterAddress(Properties properties) {
        if (StringUtils.isBlank(masterAddress)) {
            masterAddress = System.getProperty(MASTER_ADDRESS_SYS_KEY);
        }
        if (StringUtils.isBlank(masterAddress)) {
            masterAddress = System.getenv(MASTER_ADDRESS_ENV_KEY);
        }
        if (StringUtils.isBlank(masterAddress)) {
            masterAddress = properties.getProperty(MASTER_ADDRESS);
        }
    }

    private static void parseAccessAddress(Properties properties) {
        if (StringUtils.isBlank(accessAddress)) {
            accessAddress = System.getProperty(ACCESS_ADDRESS_SYS_KEY);
        }
        if (StringUtils.isBlank(accessAddress)) {
            accessAddress = System.getenv(ACCESS_ADDRESS_ENV_KEY);
        }
        if (StringUtils.isBlank(accessAddress)) {
            accessAddress = properties.getProperty(ACCESS_ADDRESS);
        }
    }

    private static void parseTransformSpringBean(Properties properties) {
        String transformSpringBeanStr = System.getProperty(TRANSFORM_SPRING_BEAN_SYS);
        if (StringUtils.isBlank(transformSpringBeanStr)) {
            transformSpringBeanStr = properties.getProperty(TRANSFORM_SPRING_BEAN);
        }
        if (StringUtils.isBlank(transformSpringBeanStr)) {
            transformSpringBeanStr = System.getenv(TRANSFORM_SPRING_BEAN_ENV);
        }
        if (TRANSFORM_SPRING_BEAN_CLOSE_VALUE.equalsIgnoreCase(transformSpringBeanStr)) {
            transformSpringBean = false;
        }
    }

    private static void parseProxyList(Properties properties) {
        if (proxyList.length > 0) {
            return;
        }
        String proxyString = System.getProperty(SYS_PROXY_LIST);
        if (StringUtils.isBlank(proxyString)) {
            proxyString = System.getenv(ENV_PROXY_LIST);
        }
        if (StringUtils.isBlank(proxyString)) {
            proxyString = properties.getProperty(PROXY);
        }
        if (!StringUtils.isBlank(proxyString)) {
            proxyList = proxyString.trim().split(",");
        }
    }

    private static void parseSpringBeanIncludePath(Properties properties) {
        if (springBeanIncludePathList.length > 0) {
            return;
        }
        String proxyString = System.getProperty(SPRING_BEAN_INCLUDE_PATH_SYS);
        if (StringUtils.isBlank(proxyString)) {
            proxyString = System.getenv(SPRING_BEAN_INCLUDE_PATH_ENV);
            LOGGER.info("env: APM_SPRING_BEAN_INCLUDE_PATHvalue: " + proxyString);
        }
        if (StringUtils.isBlank(proxyString)) {
            proxyString = properties.getProperty(SPRING_BEAN_INCLUDE_PATH_CONFIG);
            LOGGER.info("config: apm.spring.bean.exclude.pathvalue: " + proxyString);
        }
        if (!StringUtils.isBlank(proxyString)) {
            String[] includePathList = proxyString.trim().split(";");
            if (includePathList.length > 20) {
                springBeanIncludePathList = new String[20];
                System.arraycopy(includePathList, 0, springBeanIncludePathList, 0, 20);
            } else {
                springBeanIncludePathList = includePathList;
            }
        }
        for (String s : springBeanIncludePathList) {
            LOGGER.log(Level.INFO, "springBeanIncludePathList include: " + s);
        }
    }

    private static void parseSpringBeanExcludePath(Properties properties) {
        if (springBeanExcludePathList.length > 0) {
            return;
        }
        String proxyString = System.getProperty(SPRING_BEAN_EXCLUDE_PATH_SYS);
        if (StringUtils.isBlank(proxyString)) {
            proxyString = System.getenv(SPRING_BEAN_EXCLUDE_PATH_ENV);
            LOGGER.info("env: APM_SPRING_BEAN_EXCLUDE_PATHvalue: " + proxyString);
        }
        if (StringUtils.isBlank(proxyString)) {
            proxyString = properties.getProperty(SPRING_BEAN_EXCLUDE_PATH_CONFIG);
            LOGGER.info("config: apm.spring.bean.exclude.pathvalue: " + proxyString);
        }
        if (!StringUtils.isBlank(proxyString)) {
            String[] excludePathList = proxyString.trim().split(";");
            if (excludePathList.length > 20) {
                springBeanExcludePathList = new String[20];
                System.arraycopy(excludePathList, 0, springBeanExcludePathList, 0, 20);
            } else {
                springBeanExcludePathList = excludePathList;
            }
        }
        for (String s : springBeanExcludePathList) {
            LOGGER.log(Level.INFO, "springBeanExcludePathList include: " + s);
        }
    }

    private static void parseSpringBeanMaxNumber(Properties properties) {
        String springBeanMaxNumberStr = System.getenv(SPRING_BEAN_MAX_NUMBER_ENV);
        if (StringUtils.isBlank(springBeanMaxNumberStr)) {
            springBeanMaxNumberStr = properties.getProperty(SPRING_BEAN_MAX_NUMBER_CONFIG);
        }
        if (!StringUtils.isBlank(springBeanMaxNumberStr)) {
            try {
                springBeanMaxNumber = Integer.valueOf(springBeanMaxNumberStr);
                if (springBeanMaxNumber > 3000 || springBeanMaxNumber < 1) {
                    springBeanMaxNumber = 2000;
                }
            }
            catch (NumberFormatException e) {
                springBeanMaxNumber = 2000;
            }
        } else {
            springBeanMaxNumber = 2000;
        }
    }

    private static void parseMasterAuthSk(Properties properties) {
        if (StringUtils.isBlank(masterAuthSk)) {
            masterAuthSk = System.getProperty(MASTER_SECRET_KEY_SYS_KEY);
        }
        if (StringUtils.isBlank(masterAuthSk)) {
            masterAuthSk = System.getenv(MASTER_SECRET_KEY_ENV_KEY);
        }
        if (StringUtils.isBlank(masterAuthSk)) {
            masterAuthSk = properties.getProperty(MASTER_SECRET_KEY);
        }
    }

    private static void parseMasterAuthAk(Properties properties) {
        if (StringUtils.isBlank(masterAuthAk)) {
            masterAuthAk = System.getProperty(MASTER_ACCESS_KEY_SYS_KEY);
        }
        if (StringUtils.isBlank(masterAuthAk)) {
            masterAuthAk = System.getenv(MASTER_ACCESS_KEY_ENV_KEY);
        }
        if (StringUtils.isBlank(masterAuthAk)) {
            masterAuthAk = properties.getProperty(MASTER_ACCESS_KEY);
        }
    }

    private static void parseOtelEndpoint(Properties properties) {
        if (StringUtils.isBlank(otelEndPoint)) {
            otelEndPoint = System.getProperty(SYS_OTEL_EXPORTER_TRACES_ENDPOINT);
        }
        if (StringUtils.isBlank(otelEndPoint)) {
            otelEndPoint = System.getenv(ENV_OTEL_EXPORTER_TRACES_ENDPOINT);
        }
        if (StringUtils.isBlank(otelEndPoint)) {
            otelEndPoint = properties.getProperty(CONFIG_OTEL_EXPORTER_TRACES_ENDPOINT);
        }
        LOGGER.info("otelEndPoint is:" + otelEndPoint);
    }

    private static void parseOtelAuthentication(Properties properties) {
        String otelHeaderString = System.getProperty(SYS_OTEL_EXPORTER_HEADERS);
        LOGGER.info("otelHeaderString is " + otelHeaderString);
        if (StringUtils.isBlank(otelHeaderString)) {
            otelHeaderString = System.getenv(ENV_OTEL_EXPORTER_TRACES_HEADERS);
        }
        if (StringUtils.isBlank(otelHeaderString)) {
            otelHeaderString = properties.getProperty(CONFIG_OTEL_EXPORTER_HEADERS);
        }
        if (!StringUtils.isBlank(otelHeaderString)) {
            String[] headers;
            for (String header : headers = otelHeaderString.split(",")) {
                String[] split = header.split("=");
                LOGGER.info(split[0] + " : " + split[1]);
                otelHeaders.put(split[0], split[1]);
            }
        }
        LOGGER.info("otelAuthentication is:" + otelHeaders);
    }

    private static void parseOtelServiceName(Properties properties) {
        if (StringUtils.isBlank(otelServiceName)) {
            otelServiceName = System.getProperty(SYS_OTEL_SERVICE_NAME);
        }
        if (StringUtils.isBlank(otelServiceName)) {
            otelServiceName = System.getenv(ENV_OTEL_SERVICE_NAME);
        }
        if (StringUtils.isBlank(otelServiceName)) {
            otelServiceName = properties.getProperty(CONFIG_OTEL_SERVICE_NAME);
        }
        LOGGER.info("otelServiceName is:" + otelServiceName);
    }

    private static boolean parseOtelEnable(Properties properties) {
        String apmOtelEnable = System.getProperty(SYS_APM_OTPL_ENABLE);
        if (StringUtils.isBlank(apmOtelEnable)) {
            apmOtelEnable = System.getenv(ENV_APM_OTPL_ENABLE);
        }
        if (StringUtils.isBlank(apmOtelEnable)) {
            apmOtelEnable = properties.getProperty(CONFIG_APM_OTPL_ENABLE);
        }
        apmOtelEnabled = "true".equals(Optional.ofNullable(apmOtelEnable).orElse(TRANSFORM_SPRING_BEAN_CLOSE_VALUE));
        LOGGER.info("apmOptlEnabled is:" + apmOtelEnabled);
        return apmOtelEnabled;
    }

    public static boolean isApmOtelEnabled() {
        return apmOtelEnabled;
    }

    public static void setApmOtelEnabled(boolean apmOtelEnabled) {
        AgentConfigManager.apmOtelEnabled = apmOtelEnabled;
    }

    private static void getDecryptSK(String configPath, Properties properties) {
        String decryptClassName = properties.getProperty(DECRYPT_CLASS_NAME);
        String decryptMethodName = properties.getProperty(DECRYPT_METHOD_NAME);
        if (!StringUtils.isBlank(decryptClassName) && !StringUtils.isBlank(decryptMethodName)) {
            String encryptUrl = configPath + File.separator + DECRYPT_PACKAGE;
            final List<URL> libUrls = FileUtils.getLibUrl(encryptUrl);
            URLClassLoader pluginClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new URLClassLoader(libUrls.toArray(new URL[libUrls.size()]), ClassLoader.getSystemClassLoader());
                }
            });
            try {
                LOGGER.log(Level.INFO, "start decrypt user sk .");
                Class<?> encryptClass = pluginClassLoader.loadClass(decryptClassName);
                Method declaredMethod = encryptClass.getDeclaredMethod(decryptMethodName, String.class);
                String decryptSK = (String)declaredMethod.invoke(encryptClass, masterAuthSk);
                LOGGER.log(Level.INFO, "decrypt user sk end .");
                if (!StringUtils.isBlank(decryptSK)) {
                    masterAuthSk = decryptSK;
                }
                pluginClassLoader.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "[APM CONFIG]masterAuthSk decrypt failed.", e);
            }
        }
        if (!StringUtils.isBlank(masterAuthSk) && masterAuthSk.startsWith("E(")) {
            AgentConfigManager.decryptAPMSK(configPath);
        }
        if (!StringUtils.isBlank(masterAuthSk) && masterAuthSk.startsWith("C[")) {
            AgentConfigManager.decryptCSESK();
        }
    }

    private static void decryptAPMSK(String configPath) {
        String sk = masterAuthSk.substring(2, masterAuthSk.length() - 1);
        String keyStr = FileUtils.readFile(configPath + File.separator + ".apmk").trim();
        String ivStr = FileUtils.readFile(configPath + File.separator + ".apmi").trim();
        String result = APIService.getDecryptAPI().decrypt(sk, keyStr, ivStr);
        if (!StringUtils.isBlank(result)) {
            masterAuthSk = result.trim();
        }
    }

    private static void decryptCSESK() {
        String decryptSK = masterAuthSk.substring(2, masterAuthSk.length() - 1);
        decryptSK = APIService.getDecryptAPI().decryptCSESK(decryptSK);
        if (!StringUtils.isBlank(decryptSK)) {
            masterAuthSk = decryptSK;
        }
    }

    private static void getBodyConfig(Properties properties) {
        String collectSQLResultStr;
        String collectBodyStr = properties.getProperty(COLLECT_BODY);
        collectBody = "true".equals(collectBodyStr);
        String collectMethodBodyStr = properties.getProperty(COLLECT_METHOD_BODY);
        collectMethodBody = "true".equals(collectMethodBodyStr);
        String collectHttpClientBodyStr = properties.getProperty(COLLECT_HTTPCLIENT_BODY);
        collectHttpClientBody = "true".equals(collectHttpClientBodyStr);
        String collectBodyLengthStr = properties.getProperty(COLLECT_BODY_LENGTH);
        if (collectBodyLengthStr != null) {
            try {
                collectBodyLength = Integer.valueOf(collectBodyLengthStr);
            }
            catch (NumberFormatException e) {
                collectBodyLength = 9999;
            }
        } else {
            collectBodyLength = 9999;
        }
        collectSQLResult = "true".equals(collectSQLResultStr = properties.getProperty(COLLECT_SQL_RESULT));
    }

    private static void checkAgentConfig() {
        if (!ParamCheckUtils.isUrl(masterAddress)) {
            throw new IllegalArgumentException(String.format("[AGENT CONFIG]master address[%s] illegal.", masterAddress));
        }
        if (AgentConfigManager.getProxyList() != null && AgentConfigManager.getProxyList().length > 10) {
            throw new IllegalArgumentException(String.format("[AGENT CONFIG]proxy list[%s] illegal.", AgentConfigManager.getProxyList() == null ? "" : Arrays.asList(AgentConfigManager.getProxyList()).toString()));
        }
    }

    public static String getMasterAddress() {
        return masterAddress;
    }

    public static void setMasterAddress(String masterAddress) {
        AgentConfigManager.masterAddress = masterAddress;
    }

    public static boolean isFilterLogMessage() {
        return filterLogMessage;
    }

    public static void setFilterLogMessage(boolean filterLogMessage) {
        AgentConfigManager.filterLogMessage = filterLogMessage;
    }

    public static String getMasterAuthAk() {
        return masterAuthAk;
    }

    public static int getHttpClientTo() {
        return httpClientTo;
    }

    public static void setMasterAuthAk(String masterAuthAk) {
        AgentConfigManager.masterAuthAk = masterAuthAk;
    }

    public static String getMasterAuthSk() {
        return masterAuthSk;
    }

    public static void setMasterAuthSk(String masterAuthSk) {
        AgentConfigManager.masterAuthSk = masterAuthSk;
    }

    public static String[] getProxyList() {
        return (String[])proxyList.clone();
    }

    public static void setProxyList(String[] proxyList) {
        AgentConfigManager.proxyList = (String[])proxyList.clone();
    }

    public static String[] getSpringBeanIncludePathList() {
        return (String[])springBeanIncludePathList.clone();
    }

    public static String[] getSpringBeanExcludePathList() {
        return (String[])springBeanExcludePathList.clone();
    }

    public static String getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(String logLevel) {
        Level level = AgentConfigManager.getLevel(logLevel);
        Logger logger = LogFactory.getLogger();
        if (logger != null) {
            logger.setLevel(level);
        }
        AgentConfigManager.logLevel = logLevel;
    }

    public static int getEventThreadCount() {
        return eventThreadCount;
    }

    public static void setEventThreadCount(int eventThreadCount) {
        AgentConfigManager.eventThreadCount = eventThreadCount;
    }

    public static Level getLevel(String levelStr) {
        if (levelStr != null) {
            if ("error".equals(levelStr.toLowerCase())) {
                return Level.SEVERE;
            }
            if ("debug".equals(levelStr.toLowerCase())) {
                return Level.FINE;
            }
        }
        return Level.INFO;
    }

    public static String getAccessAddress() {
        return accessAddress;
    }

    public static boolean isCollectBody() {
        if (!isKunPeng) {
            return false;
        }
        return collectBody;
    }

    public static boolean isCollectSQLResult() {
        if (!isKunPeng) {
            return false;
        }
        return collectSQLResult;
    }

    public static void setCollectBody(boolean collectBody) {
        AgentConfigManager.collectBody = collectBody;
    }

    public static boolean isCollectMethodBody() {
        if (!isKunPeng) {
            return false;
        }
        return collectMethodBody;
    }

    public static boolean isCollectHttpClientBody() {
        if (!isKunPeng) {
            return false;
        }
        return collectHttpClientBody;
    }

    public static void setCollectMethodBody(boolean collectMethodBody) {
        AgentConfigManager.collectMethodBody = collectMethodBody;
    }

    public static int getCollectBodyLength() {
        return collectBodyLength;
    }

    public static void setCollectBodyLength(int collectBodyLength) {
        AgentConfigManager.collectBodyLength = collectBodyLength;
    }

    public static int getSpringBeanMaxNumber() {
        return springBeanMaxNumber;
    }

    public static void setSpringBeanMaxNumber(int springBeanMaxNumber) {
        AgentConfigManager.springBeanMaxNumber = springBeanMaxNumber;
    }

    public static boolean isServerLess() {
        return isServerLess;
    }

    public static void setServerLess(boolean isServerLess) {
        AgentConfigManager.isServerLess = isServerLess;
    }

    public static boolean isTxEnable() {
        return txEnable;
    }

    public static void setTxEnable(boolean txEnable) {
        AgentConfigManager.txEnable = txEnable;
    }

    public static Boolean isSecureChannel() {
        return secureChannel;
    }

    public static void setSecureChannel(Boolean secureChannel) {
        AgentConfigManager.secureChannel = secureChannel;
    }

    public static boolean isClosed() {
        return isClosed;
    }

    public static void setClosed(boolean isClosed) {
        AgentConfigManager.isClosed = isClosed;
    }

    public static boolean isTransformSpringBean() {
        return transformSpringBean;
    }

    public static void setTransformSpringBean(boolean transformSpringBean) {
        AgentConfigManager.transformSpringBean = transformSpringBean;
    }

    public static boolean isDrap() {
        return isDrap;
    }

    public static void setDrap(boolean isDrap) {
        AgentConfigManager.isDrap = isDrap;
    }

    public static String getOffHeapFileDir() {
        return offHeapFileDir;
    }

    public static int getOffHeapFilesAmount() {
        return offHeapFilesAmount;
    }

    public static int getOffHeapReadBatchSize() {
        return offHeapReadBatchSize;
    }

    public static String getOtelEndPoint() {
        return otelEndPoint;
    }

    public static Map<String, String> getOtelHeaders() {
        return otelHeaders;
    }

    public static String getOtelServiceName() {
        return otelServiceName;
    }

    static {
        collectBody = false;
        collectSQLResult = false;
        collectMethodBody = false;
        collectHttpClientBody = false;
        transformSpringBean = true;
        isKunPeng = false;
        collectBodyLength = 9999;
        springBeanMaxNumber = 2000;
        otelEndPoint = "";
        otelHeaders = new HashMap<String, String>();
        otelServiceName = "";
        LOGGER = LogFactory.getLogger();
        filterLogMessage = false;
    }
}

