/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultServerNodeStats
extends DefaultSectionStats {
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();

    public void onError(String errorTraceId) {
        this.onError();
        this.setErrorTraceId(errorTraceId);
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put("lastError", this.lastError.get());
        row.put("slowTraceId", this.slowTraceId.get());
        row.put("errorTraceId", this.errorTraceId.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put("lastError", this.lastError.getAndSet(null));
        row.put("slowTraceId", this.slowTraceId.getAndSet(null));
        row.put("errorTraceId", this.errorTraceId.getAndSet(null));
        return row;
    }
}

