/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.sample;

import com.lubanops.apm.bootstrap.sample.SampleType;

public class SampleConfig {
    private static final int DEFAULT_PERCENTAGE = 10;
    private static final int DEFAULT_PERIOD_COUNT = 1000;
    private String sampleType = SampleType.automatic.value();
    private Integer percentage = 10;
    private Integer periodCount = 1000;

    public String getSampleType() {
        if (SampleType.frequency.value().equals(this.sampleType) && this.periodCount == null && SampleType.percentage.value().equals(this.sampleType) && this.percentage == null) {
            return null;
        }
        return this.sampleType;
    }

    public void setSampleType(String sampleType) {
        this.sampleType = sampleType == null ? SampleType.automatic.value() : sampleType;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        if (percentage != null) {
            try {
                this.percentage = Integer.valueOf(percentage);
            }
            catch (Exception e) {
                this.percentage = 10;
            }
        } else {
            this.percentage = 10;
        }
    }

    public Integer getPeriodCount() {
        return this.periodCount;
    }

    public void setPeriodCount(String periodCount) {
        if (periodCount != null) {
            try {
                this.periodCount = Integer.valueOf(periodCount);
            }
            catch (Exception e) {
                this.periodCount = 1000;
            }
        } else {
            this.periodCount = 1000;
        }
    }

    public void setPercentage(Integer percentage) {
        this.percentage = percentage;
    }

    public void setPeriodCount(Integer periodCount) {
        this.periodCount = periodCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SampleConfig{");
        sb.append("sampleType='").append(this.sampleType).append('\'');
        sb.append(", percentage=").append(this.percentage);
        sb.append(", periodCount=").append(this.periodCount);
        sb.append('}');
        return sb.toString();
    }
}

