/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import com.lubanops.apm.bootstrap.config.ConfigManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ConcurrentHashMap;

public class ExceptionUtil {
    public static final int MAX_ERROR_STACK_LENGTH = 4096;

    public static String getThrowableStackTrace(Throwable t, boolean hideExceptionMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String s = sw.toString();
        String lineSep = System.getProperty("line.separator");
        if (hideExceptionMessage) {
            int endIndex = s.indexOf(":");
            int startIndex = s.indexOf(lineSep);
            if (endIndex > -1 && startIndex > -1) {
                s = s.substring(0, endIndex) + s.substring(startIndex);
            }
        }
        if (s.length() > ConfigManager.getMaxExceptionLength()) {
            s = s.substring(0, ConfigManager.getMaxExceptionLength());
        }
        return s;
    }

    public static String getThrowableStackTrace(Throwable t, int maxStackLength, boolean hideExceptionMessage) {
        if (maxStackLength <= 0) {
            maxStackLength = ConfigManager.getMaxExceptionLength();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String s = sw.toString();
        String lineSep = System.getProperty("line.separator");
        if (hideExceptionMessage) {
            s = s.substring(0, s.indexOf(":")) + s.substring(s.indexOf(lineSep));
        }
        if (s.length() > maxStackLength) {
            s = s.substring(0, maxStackLength);
        }
        return s;
    }

    public static String getThrowableStackTrace(Throwable t) {
        return ExceptionUtil.getThrowableStackTrace(t, ConfigManager.isHideExceptionMessage());
    }

    public static void main(String[] args) {
        try {
            ConcurrentHashMap<Object, String> m = new ConcurrentHashMap<Object, String>();
            m.put(null, "1");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

