/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.reactornetty.client.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.url.collector.WebContainerType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import io.opentelemetry.api.trace.Span;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.client.HttpClientRequest;

public class HttpObserverInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                Object obj;
                if ("onStateChange".equals(methodName)) {
                    this.onStateChange(object, args);
                } else if (args[1] != null && args[1] instanceof TransformAccess && args[0] != null && args[0] instanceof TransformAccess && (obj = ((TransformAccess)args[1]).getLopsAttribute()) != null) {
                    Map map = (Map)obj;
                    SpanEvent spanEvent = (SpanEvent)map.get("spanevent");
                    String url = (String)map.get("url");
                    URL netUrl = new URL(url);
                    String host = netUrl.getProtocol() + "://" + netUrl.getAuthority();
                    String method = (String)map.get("method");
                    String gtraceId = (String)map.get("gtraceId");
                    String userFlag = (String)map.get("userFlag");
                    String policyId = (String)map.get("policyId");
                    List txName = (List)map.get("txName");
                    long startTime = System.currentTimeMillis();
                    long nanoTime = System.nanoTime();
                    Map newMap = HttpClientCollector.onStartAsync((String)host, (String)url, (String)method, (String)WebContainerType.ReactorNetty.name());
                    if (spanEvent != null) {
                        spanEvent.setStartTime(startTime);
                        spanEvent.setStartNanoTime(nanoTime);
                        spanEvent.addTag("url", url);
                        spanEvent.addTag("httpMethod", method);
                        newMap.put("spanevent", spanEvent);
                        newMap.put("policyId", policyId);
                        Span otelSpan = spanEvent.getOtelSpan();
                        TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.method", (Object)method);
                        TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.url", (Object)url);
                    }
                    newMap.put("gtraceId", gtraceId);
                    newMap.put("txName", txName);
                    newMap.put("userFlag", userFlag);
                    newMap.put("url", url);
                    ((TransformAccess)args[1]).setLopsAttribute((Object)newMap);
                    ((TransformAccess)args[0]).setLopsAttribute((Object)newMap);
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
        return null;
    }

    private void onStateChange(Object object, Object[] args) {
        Object[] fileds;
        ConnectionObserver.State newState = (ConnectionObserver.State)args[1];
        if (newState == ConnectionObserver.State.CONFIGURED && args[0] instanceof TransformAccess && object instanceof AttributeAccess && (fileds = ((AttributeAccess)object).getLopsFileds())[0] != null && fileds[0] instanceof TransformAccess && args[0] instanceof HttpClientRequest) {
            HttpClientRequest request = (HttpClientRequest)args[0];
            request.header((CharSequence)Headers.ENV_ID.getValue(), (CharSequence)String.valueOf(IdentityConfigManager.getEnvId()));
            request.header((CharSequence)Headers.DOMAIN_ID.getValue(), (CharSequence)String.valueOf(IdentityConfigManager.getDomainId()));
            request.header((CharSequence)Headers.DOMAIN_TYPE.getValue(), (CharSequence)String.valueOf(IdentityConfigManager.getDomainType()));
            Object obj = ((TransformAccess)fileds[0]).getLopsAttribute();
            if (obj != null) {
                ((TransformAccess)args[0]).setLopsAttribute(obj);
                Map map = (Map)obj;
                SpanEvent spanEvent = (SpanEvent)map.get("spanevent");
                if (spanEvent != null) {
                    request.header((CharSequence)Headers.TRACE_ID.getValue(), (CharSequence)spanEvent.getTraceId());
                    request.header((CharSequence)Headers.SPAN_ID.getValue(), (CharSequence)spanEvent.getNextSpanId());
                    request.header((CharSequence)Headers.SOURCE_EVENT_ID.getValue(), (CharSequence)spanEvent.getEventId());
                    if (spanEvent.hasSamplingPolicy()) {
                        request.header((CharSequence)Headers.POLICY_ID.getValue(), (CharSequence)spanEvent.getPolicyId());
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    TraceCollector.injectHeader(headers, (Span)spanEvent.getOtelSpan());
                    if (!headers.isEmpty()) {
                        headers.forEach((k, v) -> request.addHeader((CharSequence)k, (CharSequence)v));
                    }
                }
                String gtraceId = (String)map.get("gtraceId");
                String userFlag = (String)map.get("userFlag");
                List txName = (List)map.get("txName");
                if (gtraceId != null) {
                    request.header((CharSequence)Headers.GTRACE_ID.getValue(), (CharSequence)gtraceId);
                }
                if (txName != null && txName.size() > 0) {
                    request.header((CharSequence)Headers.TXNANE_ID.getValue(), (CharSequence)StringUtils.joinTxList((CharSequence)",", (List)txName));
                }
                if (userFlag != null) {
                    request.header((CharSequence)Headers.USER_FLAG.getValue(), (CharSequence)userFlag);
                }
            }
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

