/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jedis.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.jedis.collector.JedisCollector;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.pool2.impl.GenericObjectPool;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.HostAndPort;

public class JedisPoolConstructorInterceptor
implements Interceptor {
    public static final int PORT_POS = 2;
    public static final Pattern PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");
    public static final Pattern IP_PATTERN = Pattern.compile("([1-9]|[1-9]\\d|1\\d{2}|2[0-1]\\d|22[0-3])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");

    public JedisPoolConstructorInterceptor() {
        String version = Util.getJarVersionFromProtectionDomain((ProtectionDomain)BinaryJedis.class.getProtectionDomain());
        JedisCollector.setJedisVersion(version);
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (object instanceof AttributeAccess) {
            String hostAndPort = "";
            if (args[1] instanceof HostAndPort) {
                hostAndPort = args[1].toString();
            }
            if (args.length > 2 && JedisPoolConstructorInterceptor.isIp(args[1].toString()) && JedisPoolConstructorInterceptor.isInteger(args[2].toString())) {
                String host = args[1].toString();
                int port = Integer.parseInt(args[2].toString());
                hostAndPort = host + ":" + port;
            }
            if (!StringUtils.isBlank((String)hostAndPort)) {
                Object[] fieldObjects = ((AttributeAccess)object).getLopsFileds();
                GenericObjectPool genericObjectPool = (GenericObjectPool)fieldObjects[0];
                JedisCollector.getInstance().onJedisPoolCreated(hostAndPort, genericObjectPool);
            }
        }
    }

    public static boolean isIp(String ip) {
        Matcher matcher = IP_PATTERN.matcher(ip);
        return matcher.matches();
    }

    public static boolean isInteger(String str) {
        return PATTERN.matcher(str).matches();
    }
}

