/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.master;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.core.master.AbstractMasterService;
import com.lubanops.apm.core.transfer.dto.HeartBeatRequest;
import com.lubanops.apm.core.transfer.dto.HeartBeatResult;
import com.lubanops.apm.core.transfer.dto.RegisterRequest;
import com.lubanops.apm.core.transfer.dto.RegisterResult;
import com.lubanops.apm.core.utils.HttpClientUtil;
import com.lubanops.apm.integration.utils.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RegionMasterService
extends AbstractMasterService {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final String REGISTER_URL = "/apm2/master/v1/register";
    private static final String HEARTBEAT_URL = "/apm2/master/v1/heartbeat";
    private static RegionMasterService instance;
    private List<String> masterAddressList = new ArrayList<String>();

    public static synchronized RegionMasterService getInstance() {
        if (instance == null) {
            instance = new RegionMasterService();
        }
        return instance;
    }

    public RegionMasterService() {
        super(REGISTER_URL);
        if (!StringUtils.isBlank((CharSequence)AgentConfigManager.getMasterAddress())) {
            String[] masterAddresses = AgentConfigManager.getMasterAddress().split(",");
            List<String> masterAddressList = Arrays.asList(masterAddresses);
            this.setMasterAddressList(masterAddressList);
        }
    }

    @Override
    protected RegisterResult doRegister(RegisterRequest request) {
        RegisterResult registerResult = null;
        String requestStr = JSON.toJSONString((Object)request);
        HttpClientUtil.Result result = HttpClientUtil.sendPostToServer(this.masterAddressList, AgentConfigManager.getProxyList(), REGISTER_URL, requestStr);
        if (result != null) {
            int code = result.getStatus();
            if (code == 200) {
                RegisterResult newRegisterResult = (RegisterResult)JSON.parseObject((String)result.getContent(), RegisterResult.class);
                if (newRegisterResult != null && newRegisterResult.getErrorCode() == null) {
                    registerResult = newRegisterResult;
                } else if (newRegisterResult != null && newRegisterResult.getErrorCode() != null) {
                    LOGGER.log(Level.SEVERE, String.format("[APM MASTER]registry error result[%s]", newRegisterResult), (Throwable)new ApmRuntimeException(newRegisterResult.getErrorMsg()));
                }
            } else {
                LOGGER.log(Level.SEVERE, String.format("[APM MASTER]registry error result[%s]", result));
            }
        }
        return registerResult;
    }

    @Override
    protected HeartBeatResult doHeartbeat(HeartBeatRequest heartBeatRequest) {
        HeartBeatResult newHeartBeatResult = null;
        String requestStr = JSON.toJSONString((Object)heartBeatRequest);
        HttpClientUtil.Result result = HttpClientUtil.sendPostToServer(this.masterAddressList, AgentConfigManager.getProxyList(), HEARTBEAT_URL, requestStr);
        if (result != null) {
            int code = result.getStatus();
            if (code == 200) {
                newHeartBeatResult = (HeartBeatResult)JSON.parseObject((String)result.getContent(), HeartBeatResult.class);
                LOGGER.log(Level.FINE, "[APM MASTER]heartbeat result: " + result);
            } else {
                LOGGER.log(Level.SEVERE, String.format("[APM MASTER]heartbeat to master return unexpect code,raw result:[%s]", result));
            }
        }
        return newHeartBeatResult;
    }

    public List<String> getMasterAddressList() {
        return this.masterAddressList;
    }

    private void setMasterAddressList(List<String> masterAddressList) {
        this.masterAddressList = masterAddressList;
    }
}

