/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transaction;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.core.transaction.TransactionReportService;
import com.lubanops.apm.core.transaction.TransactionReportServiceImpl;
import com.lubanops.apm.integration.access.inbound.TxDataBody;
import java.util.List;

public class TxHarvestTask {
    private static final Logger LOG = LogFactory.getLogger();
    private TransactionReportService transactionReportService = TransactionReportServiceImpl.getInstance();
    private static TxHarvestTask instance;

    public static synchronized TxHarvestTask getInstance() {
        if (instance == null) {
            instance = new TxHarvestTask();
        }
        return instance;
    }

    public void run() {
        try {
            this.harvest();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "failed to harvest:", (Throwable)e);
        }
    }

    private void harvest() {
        List transactions = TransactionCollector.harvest();
        if (transactions == null || transactions.isEmpty()) {
            return;
        }
        TxDataBody body = new TxDataBody();
        body.setTransactions(transactions);
        long harvestTime = System.currentTimeMillis();
        body.setTimestamp(harvestTime);
        this.transactionReportService.offer(body);
    }
}

