/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.utils;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.ISpanEventPool;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.core.utils.SpanEventFactory;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class SpanEventPoolImpl
implements ISpanEventPool {
    long last_error = System.currentTimeMillis();
    public GenericObjectPool<SpanEvent> pool;
    private static volatile SpanEventPoolImpl instance;
    private int MAX = AgentConfigManager.getMaxEventsInProcess();
    private int HIGH_WATER_LINE = Math.min(2 * this.MAX, 10000);
    private int LOW_WATER_LINE = Math.min(this.MAX / 2, 100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpanEventPoolImpl getInstance() {
        if (instance != null) return instance;
        Class<SpanEventPoolImpl> clazz = SpanEventPoolImpl.class;
        synchronized (SpanEventPoolImpl.class) {
            if (instance != null) return instance;
            if (AgentConfigManager.getMaxEventsInProcess() == 0) {
                instance = new DummyPool();
                LogFactory.getLogger().severe("Create dummy pool");
            } else {
                instance = new SpanEventPoolImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SpanEventPoolImpl() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.HIGH_WATER_LINE);
        config.setBlockWhenExhausted(false);
        config.setTestOnReturn(false);
        config.setMaxIdle(this.LOW_WATER_LINE);
        config.setMinEvictableIdleTimeMillis(60000L);
        config.setTimeBetweenEvictionRunsMillis(1800000L);
        this.pool = new GenericObjectPool((PooledObjectFactory)new SpanEventFactory(), config);
        this.pool.setAbandonedConfig(new AbandonedConfig());
        try {
            PoolUtils.prefill(this.pool, (int)(this.HIGH_WATER_LINE / 2));
        }
        catch (Exception e) {
            LogFactory.getLogger().severe("Failed to prefill pool");
        }
    }

    private SpanEvent get() {
        SpanEvent event = null;
        try {
            event = (SpanEvent)this.pool.borrowObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return event;
    }

    public SpanEvent get(String traceId, String spanId, String domainId) {
        SpanEvent event = this.get();
        if (event != null) {
            event.init(traceId, spanId, domainId);
        } else {
            event = new SpanEvent(traceId, spanId, domainId);
        }
        return event;
    }

    public SpanEvent get(SpanEvent root) {
        SpanEvent event = this.get();
        if (event != null) {
            event.init(root);
        } else {
            event = new SpanEvent(root);
        }
        return event;
    }

    public void recycle(SpanEvent event) {
        try {
            this.pool.returnObject((Object)event);
        }
        catch (Exception e) {
            LogFactory.getLogger().severe("Failed to return span event" + e.getMessage());
        }
    }

    static class DummyPool
    extends SpanEventPoolImpl {
        DummyPool() {
        }

        @Override
        public SpanEvent get(String traceId, String spanId, String domainId) {
            return new SpanEvent(traceId, spanId, domainId);
        }

        @Override
        public SpanEvent get(SpanEvent root) {
            return new SpanEvent(root);
        }

        @Override
        public void recycle(SpanEvent event) {
        }
    }
}

