/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.taobao.arthas.core.command.model.StackModel;
import java.util.ArrayList;

public class StackModelToPDebuggerResponseConverter
extends ArthasModelToPDebuggerConverter {
    public static PDebuggerResponse convert(StackModel stackModel, PDebuggerRequest request) {
        PDebuggerResponse.StackResponse stackResponse = PDebuggerResponse.StackResponse.newBuilder().setCost(stackModel.getCost()).setThreadName(stackModel.getThreadName()).setThreadId(stackModel.getThreadId()).addAllStackTrace(StackModelToPDebuggerResponseConverter.populateStackTraceList(stackModel.getStackTrace())).build();
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setStackResponse(stackResponse);
        return StackModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    private static Iterable<PDebuggerResponse.StackTraceElement> populateStackTraceList(StackTraceElement[] stackTrace) {
        ArrayList<PDebuggerResponse.StackTraceElement> stackTraceElementsList = new ArrayList<PDebuggerResponse.StackTraceElement>();
        for (StackTraceElement stackTraceElement : stackTrace) {
            String fileName = stackTraceElement.getFileName() != null ? stackTraceElement.getFileName() : "Unknown Source";
            stackTraceElementsList.add(PDebuggerResponse.StackTraceElement.newBuilder().setClassName(stackTraceElement.getClassName()).setMethodName(stackTraceElement.getMethodName()).setFileName(fileName).setLineNumber(stackTraceElement.getLineNumber()).setNativeMethod(stackTraceElement.isNativeMethod()).build());
        }
        return stackTraceElementsList;
    }
}

