/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.handler;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.AgentUtils;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.integration.debugger.handler.ArthasInterceptors;
import com.lubanops.apm.integration.debugger.server.DebuggerJobController;
import com.taobao.arthas.common.PidUtils;
import com.taobao.arthas.core.command.BuiltinCommandPack;
import com.taobao.arthas.core.command.model.InputStatus;
import com.taobao.arthas.core.command.model.InputStatusModel;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.distribution.PackingResultDistributor;
import com.taobao.arthas.core.distribution.ResultDistributor;
import com.taobao.arthas.core.distribution.SharingResultDistributor;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.CliTokens;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.session.SessionManager;
import com.taobao.arthas.core.shell.session.impl.SessionManagerImpl;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobController;
import com.taobao.arthas.core.shell.system.JobListener;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import com.taobao.arthas.core.shell.term.SignalHandler;
import com.taobao.arthas.core.shell.term.Term;
import io.termd.core.function.Function;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class DebuggerCommandHandler {
    private static final AtomicBoolean INITIAILIZED = new AtomicBoolean(false);
    private DebuggerJobController jobController = new DebuggerJobController();
    private InternalCommandManager commandManager;
    private SessionManager sessionManager;
    private Session session;
    private Instrumentation instrumentation;
    public static int DEFAULT_EXEC_TIMEOUT = 15000;
    private static final Logger LOGGER = LogFactory.getLogger();

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Session getSession() {
        return this.session;
    }

    private final void onTimeInitialization() {
        this.configureArthasBootstrap(this.instrumentation);
    }

    private final void configureArthasBootstrap(Instrumentation instrumentation) {
        try {
            ArthasInterceptors.addInterceptors(instrumentation);
            ArthasBootstrap.getInstance((Instrumentation)instrumentation, (String)"");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public DebuggerCommandHandler() {
        BuiltinCommandPack builtinCommands = new BuiltinCommandPack(new ArrayList());
        ArrayList<BuiltinCommandPack> resolvers = new ArrayList<BuiltinCommandPack>();
        resolvers.add(builtinCommands);
        this.commandManager = new InternalCommandManager(resolvers);
        this.instrumentation = AgentUtils.getInstrumentation();
        if (!INITIAILIZED.getAndSet(true)) {
            this.onTimeInitialization();
        }
        this.sessionManager = new SessionManagerImpl(new ShellServerOptions().setInstrumentation(this.instrumentation).setPid(PidUtils.currentLongPid()), this.commandManager, (JobController)this.jobController);
        this.session = this.sessionManager.createSession();
        Properties properties = FileUtils.readFilePropertyByPath((String)(DebuggerCommandHandler.getAgentPath() + File.separator + "apm.config"));
        DEFAULT_EXEC_TIMEOUT = properties.getProperty("arthas.timeout") != null ? Integer.parseInt(properties.getProperty("arthas.timeout")) : 15000;
    }

    private void updateSessionInputStatus(Session session, InputStatus inputStatus) {
        SharingResultDistributor resultDistributor = session.getResultDistributor();
        if (resultDistributor != null) {
            resultDistributor.appendResult((ResultModel)new InputStatusModel(inputStatus));
        }
    }

    public Boolean handle(String command, PackingResultDistributor packingResultDistributor) {
        LOGGER.log(Level.INFO, "~~~~~ handle arthas command: [" + command + "]");
        List tokens = CliTokens.tokenize((String)command);
        Job job = this.createJob(tokens, packingResultDistributor);
        if (job == null) {
            return false;
        }
        job.run();
        boolean timeExpired = !this.waitForJob(job, DEFAULT_EXEC_TIMEOUT);
        LOGGER.log(Level.INFO, "~~~~~ handle arthas command done");
        if (timeExpired) {
            job.interrupt();
            return true;
        }
        return false;
    }

    private boolean waitForJob(Job job, int timeout) {
        long startTime = System.currentTimeMillis();
        while (true) {
            switch (job.status()) {
                case STOPPED: 
                case TERMINATED: {
                    return true;
                }
            }
            if (System.currentTimeMillis() - startTime > (long)timeout) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private Job createJob(List<CliToken> tokens, PackingResultDistributor jobResultDistributor) {
        Job job;
        try {
            job = this.jobController.createJob(this.commandManager, tokens, this.session, new ArthasJobHandler(this.session), new ArthasTerm(this.session), (ResultDistributor)jobResultDistributor);
        }
        catch (Exception e) {
            return null;
        }
        return job;
    }

    public static String getAgentPath() {
        String agentPath = null;
        try {
            ProtectionDomain pd = DebuggerCommandHandler.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            String jarPath = cs.getLocation().getPath();
            agentPath = jarPath.substring(0, jarPath.lastIndexOf("core"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return agentPath;
    }

    private class ArthasJobHandler
    implements JobListener {
        private Session session;

        public ArthasJobHandler(Session session) {
            this.session = session;
        }

        public void onForeground(Job job) {
            this.session.setForegroundJob(job);
        }

        public void onBackground(Job job) {
            if (this.session.getForegroundJob() == job) {
                this.session.setForegroundJob(null);
                DebuggerCommandHandler.this.updateSessionInputStatus(this.session, InputStatus.ALLOW_INPUT);
            }
        }

        public void onTerminated(Job job) {
            if (this.session.getForegroundJob() == job) {
                this.session.setForegroundJob(null);
                DebuggerCommandHandler.this.updateSessionInputStatus(this.session, InputStatus.ALLOW_INPUT);
            }
        }

        public void onSuspend(Job job) {
            if (this.session.getForegroundJob() == job) {
                this.session.setForegroundJob(null);
                DebuggerCommandHandler.this.updateSessionInputStatus(this.session, InputStatus.ALLOW_INPUT);
            }
        }
    }

    private static class ArthasTerm
    implements Term {
        private Session session;

        public ArthasTerm(Session session) {
            this.session = session;
        }

        public Term resizehandler(Handler<Void> handler) {
            return this;
        }

        public String type() {
            return "web";
        }

        public int width() {
            return 1000;
        }

        public int height() {
            return 200;
        }

        public Term stdinHandler(Handler<String> handler) {
            return this;
        }

        public Term stdoutHandler(Function<String, String> handler) {
            return this;
        }

        public Term write(String data) {
            return this;
        }

        public long lastAccessedTime() {
            return this.session.getLastAccessTime();
        }

        public Term echo(String text) {
            return this;
        }

        public Term setSession(Session session) {
            return this;
        }

        public Term interruptHandler(SignalHandler handler) {
            return this;
        }

        public Term suspendHandler(SignalHandler handler) {
            return this;
        }

        public void readline(String prompt, Handler<String> lineHandler) {
        }

        public void readline(String prompt, Handler<String> lineHandler, Handler<Completion> completionHandler) {
        }

        public Term closeHandler(Handler<Void> handler) {
            return this;
        }

        public void close() {
        }
    }
}

