/*
 * Decompiled with CFR 0.152.
 */
import one.jfr.Dictionary;
import one.jfr.StackTrace;

class Classifier {
    private static final String GC = "[gc]";
    private static final String JIT = "[jit]";
    private static final String VM = "[vm]";
    private static final String VTABLE_STUBS = "[vtable_stubs]";
    private static final String NATIVE = "[native]";
    private static final String INTERPRETER = "[Interpreter]_[0]";
    private static final String C1_COMP = "[c1_comp]_[1]";
    private static final String C2_COMP = "[c2_comp]_[i]";
    private static final String ADAPTER = "[c2i_adapter]_[i]";
    private static final String CLASS_INIT = "[class::init]";
    private static final String CLASS_LOAD = "[class::load]";
    private static final String CLASS_RESOLVE = "[class::resolve]";
    private static final String CLASS_VERIFY = "[class::verify]";
    private static final String LAMBDA_INIT = "[lambda::init]";
    private final Dictionary<String> methodNames;

    Classifier(Dictionary<String> dictionary) {
        this.methodNames = dictionary;
    }

    public String getCategoryName(StackTrace stackTrace) {
        long[] lArray = stackTrace.methods;
        byte[] byArray = stackTrace.types;
        String string = this.detectGcJit(lArray, byArray);
        if (string == null && (string = this.detectClassLoading(lArray, byArray)) == null) {
            string = this.detectOther(lArray, byArray);
        }
        return string;
    }

    private String detectGcJit(long[] lArray, byte[] byArray) {
        boolean bl = false;
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] == 4) {
                switch (this.methodNames.get(lArray[n])) {
                    case "CompileBroker::compiler_thread_loop": {
                        return JIT;
                    }
                    case "GCTaskThread::run": 
                    case "WorkerThread::run": {
                        return GC;
                    }
                    case "java_start": 
                    case "thread_native_entry": {
                        bl = true;
                    }
                }
                continue;
            }
            if (byArray[n] == 3) continue;
        }
        return bl ? VM : null;
    }

    private String detectClassLoading(long[] lArray, byte[] byArray) {
        for (int i = 0; i < lArray.length; ++i) {
            String string = this.methodNames.get(lArray[i]);
            if (string.equals("Verifier::verify")) {
                return CLASS_VERIFY;
            }
            if (string.startsWith("InstanceKlass::initialize")) {
                return CLASS_INIT;
            }
            if (string.startsWith("LinkResolver::") || string.startsWith("InterpreterRuntime::resolve") || string.startsWith("SystemDictionary::resolve")) {
                return CLASS_RESOLVE;
            }
            if (string.endsWith("ClassLoader.loadClass")) {
                return CLASS_LOAD;
            }
            if (string.endsWith("LambdaMetafactory.metafactory") || string.endsWith("LambdaMetafactory.altMetafactory")) {
                return LAMBDA_INIT;
            }
            if (string.endsWith("table stub")) {
                return VTABLE_STUBS;
            }
            if (string.equals("Interpreter")) {
                return INTERPRETER;
            }
            if (!string.startsWith("I2C/C2I")) continue;
            return i + 1 < byArray.length && byArray[i + 1] == 0 ? INTERPRETER : ADAPTER;
        }
        return null;
    }

    private String detectOther(long[] lArray, byte[] byArray) {
        boolean bl = true;
        block18: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 0: {
                    return bl ? INTERPRETER : NATIVE;
                }
                case 1: {
                    return bl ? C2_COMP : NATIVE;
                }
                case 2: {
                    bl = true;
                    continue block18;
                }
                case 3: {
                    String string = this.methodNames.get(lArray[i]);
                    if (string.startsWith("JVM_") || string.startsWith("Unsafe_") || string.startsWith("MHN_") || string.startsWith("jni_")) {
                        return VM;
                    }
                    switch (string) {
                        case "call_stub": 
                        case "deoptimization": 
                        case "unknown_Java": 
                        case "not_walkable_Java": 
                        case "InlineCacheBuffer": {
                            return VM;
                        }
                    }
                    if (string.endsWith("_arraycopy") || string.contains("pthread_cond")) continue block18;
                    bl = false;
                    continue block18;
                }
                case 4: {
                    String string = this.methodNames.get(lArray[i]);
                    if (!string.startsWith("Runtime1::")) continue block18;
                    return C1_COMP;
                }
                case 6: {
                    return bl ? C1_COMP : NATIVE;
                }
            }
        }
        return NATIVE;
    }
}

