/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ResultSetAttribute;
import com.mysql.jdbc.ResultSetImpl;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ResultSetNextInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    private void getData(Object object, List<String[]> resultData) throws SQLException {
        int i;
        ResultSetImpl resultSet = (ResultSetImpl)object;
        ResultSetMetaData rm = resultSet.getMetaData();
        int colCount = rm.getColumnCount();
        if (resultData.size() == 0) {
            String[] cols = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String colName = rm.getColumnName(i + 1);
                String colType = rm.getColumnTypeName(i + 1);
                cols[i] = colName + "(" + colType + ")";
            }
            resultData.add(cols);
        }
        if (resultData.size() <= MysqlCollector.CONFIG.getRowsNum()) {
            String[] dataRow = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String dataValue = String.valueOf(resultSet.getObject(i + 1));
                if (dataValue.length() > MysqlCollector.CONFIG.getValueSize()) {
                    dataValue = dataValue.substring(0, MysqlCollector.CONFIG.getValueSize()) + "...";
                }
                dataRow[i] = dataValue;
            }
            resultData.add(dataRow);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ResultSetAttribute resultSetAttribute;
            if (MysqlCollector.INSTANCE.isEnable() && result instanceof Boolean && ((Boolean)result).booleanValue() && object instanceof TransformAccess && MysqlCollector.CONFIG.isBodyDetail() && (resultSetAttribute = (ResultSetAttribute)((TransformAccess)object).getLopsAttribute()) != null) {
                List data = resultSetAttribute.getResultData();
                this.getData(object, data);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

