/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.okhttpclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.otel.OtelSpanKind;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.ExcludePluginLocal;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.okhttpclient.interceptor.AsyncLocal;
import io.opentelemetry.api.trace.Span;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpClientInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            AtomicInteger bl = AsyncLocal.CONTEXT.get();
            if (bl != null) {
                int count = bl.addAndGet(1);
                if (count > 1) {
                    return new Object[0];
                }
            } else {
                AsyncLocal.CONTEXT.set(new AtomicInteger(1));
            }
            return this.startCollect(object, args, className, methodName);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
            return new Object[0];
        }
    }

    private Boolean checkFromObsPlugin() {
        if (Boolean.TRUE.equals(ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.get())) {
            return (Boolean)ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.get();
        }
        return false;
    }

    private Object[] startCollect(Object object, Object[] args, String className, String methodName) {
        if (HttpClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Request) {
            List txName;
            String userFlag;
            String gTraceId;
            Request request = (Request)args[0];
            HttpUrl httpUrl = request.url();
            int port = httpUrl.port();
            String host = httpUrl.host();
            String scheme = httpUrl.scheme();
            String hostUri = scheme + "://" + host + ":" + port;
            String requestUri = request.url().toString();
            String httpMethod = request.method();
            if (!this.checkFromObsPlugin().booleanValue()) {
                HttpClientCollector.onStart((String)hostUri, (String)requestUri, (String)httpMethod, (String)HttpClientType.Okhttpclient.name());
            }
            Request.Builder builder = request.newBuilder();
            builder.addHeader(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
            builder.addHeader(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
            builder.addHeader(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
            SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.Okhttpclient.name(), (String)httpMethod, (String)OtelSpanKind.CLIENT.name());
            if (spanEvent != null) {
                spanEvent.addTag("url", requestUri);
                spanEvent.addTag("httpMethod", httpMethod);
                String nextSpanId = spanEvent.generateNextSpanId();
                String traceId = spanEvent.getTraceId();
                builder.addHeader(Headers.TRACE_ID.getValue(), traceId);
                builder.addHeader(Headers.SPAN_ID.getValue(), nextSpanId);
                builder.addHeader(Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
                if (spanEvent.hasSamplingPolicy()) {
                    builder.addHeader(Headers.POLICY_ID.getValue(), spanEvent.getPolicyId());
                }
                Span otelSpan = spanEvent.getOtelSpan();
                TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.method", (Object)httpMethod);
                TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.url", (Object)requestUri);
            }
            if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
                builder.addHeader(Headers.GTRACE_ID.getValue(), gTraceId);
            }
            if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
                builder.addHeader(Headers.USER_FLAG.getValue(), userFlag);
            }
            if ((txName = TransactionCollector.getTxName()) != null && txName.size() > 0) {
                builder.addHeader(Headers.TXNANE_ID.getValue(), StringUtils.joinTxList((CharSequence)",", (List)txName));
            }
            args[0] = builder.build();
            return args;
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable exception, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)exception);
                if (!this.checkFromObsPlugin().booleanValue()) {
                    HttpClientCollector.onThrowable((Throwable)exception);
                }
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            int count;
            AtomicInteger bl = AsyncLocal.CONTEXT.get();
            if (bl != null && (count = bl.decrementAndGet()) > 0) {
                return;
            }
            if (HttpClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Request) {
                String envId = null;
                if (result != null && result instanceof Response && args[0] != null && args[0] instanceof Request) {
                    Request request = (Request)args[0];
                    String requestUri = request.url().toString();
                    Response response = (Response)result;
                    envId = response.header(Headers.ENV_ID.getValue());
                    int code = response.code();
                    if (!this.checkFromObsPlugin().booleanValue()) {
                        HttpClientCollector.onStatusCode((String)requestUri, (int)code);
                    }
                    TraceCollector.addTag((String)"code", (String)String.valueOf(code));
                    TraceCollector.addOtelAttribute((String)"http.status_code", (Object)String.valueOf(code));
                }
                TraceCollector.onFinally();
                if (!this.checkFromObsPlugin().booleanValue()) {
                    HttpClientCollector.onResponseClose(envId);
                }
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

