/*
 * Decompiled with CFR 0.152.
 */
package one.jfr;

public class Dictionary<T> {
    private static final int INITIAL_CAPACITY = 16;
    private long[] keys = new long[16];
    private Object[] values = new Object[16];
    private int size;

    public void clear() {
        this.keys = new long[16];
        this.values = new Object[16];
        this.size = 0;
    }

    public void put(long l, T t) {
        if (l == 0L) {
            throw new IllegalArgumentException("Zero key not allowed");
        }
        int n = this.keys.length - 1;
        int n2 = Dictionary.hashCode(l) & n;
        while (this.keys[n2] != 0L) {
            if (this.keys[n2] == l) {
                this.values[n2] = t;
                return;
            }
            n2 = n2 + 1 & n;
        }
        this.keys[n2] = l;
        this.values[n2] = t;
        if (++this.size * 2 > this.keys.length) {
            this.resize(this.keys.length * 2);
        }
    }

    public T get(long l) {
        int n = this.keys.length - 1;
        int n2 = Dictionary.hashCode(l) & n;
        while (this.keys[n2] != l && this.keys[n2] != 0L) {
            n2 = n2 + 1 & n;
        }
        return (T)this.values[n2];
    }

    public void forEach(Visitor<T> visitor) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0L) continue;
            visitor.visit(this.keys[i], this.values[i]);
        }
    }

    public int preallocate(int n) {
        if (n * 2 > this.keys.length) {
            this.resize(Integer.highestOneBit(n * 4 - 1));
        }
        return n;
    }

    private void resize(int n) {
        long[] lArray = new long[n];
        Object[] objectArray = new Object[n];
        int n2 = lArray.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0L) continue;
            int n3 = Dictionary.hashCode(this.keys[i]) & n2;
            while (true) {
                if (lArray[n3] == 0L) {
                    lArray[n3] = this.keys[i];
                    objectArray[n3] = this.values[i];
                    continue block0;
                }
                n3 = n3 + 1 & n2;
            }
        }
        this.keys = lArray;
        this.values = objectArray;
    }

    private static int hashCode(long l) {
        return (int)((l *= -4132994306676758123L) ^ l >>> 32);
    }

    public static interface Visitor<T> {
        public void visit(long var1, T var3);
    }
}

