/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KafkaProducerDoSendAggregator
extends MultiPrimaryKeyAggregator<DefaultSectionStats> {
    private ThreadLocal<Long> timeLocal = new ThreadLocal();

    public String getName() {
        return "doSendMethod";
    }

    protected int primaryKeyLength() {
        return 1;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("topic");
    }

    protected Class<DefaultSectionStats> getValueType() {
        return DefaultSectionStats.class;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void parseParameters(Map<String, String> parameters) {
        int[] range;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        if ((range = (int[])ParameterParseUtil.getParameterValue(parameters, (String)"doSendMethodRange", int[].class)) != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(new int[]{10, 100, 500, 1000, 10000});
        }
    }

    public void onStart(String topic) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{topic});
        DefaultSectionStats stats = (DefaultSectionStats)this.getValue(pk);
        long startTime = stats.onStart();
        this.timeLocal.set(startTime);
    }

    public void onThrowable(String topic, Throwable th) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{topic});
        DefaultSectionStats stats = (DefaultSectionStats)this.getValue(pk);
        if (stats != null) {
            stats.onThrowable(th);
        }
    }

    public void onFinally(String topic) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{topic});
        DefaultSectionStats stats = (DefaultSectionStats)this.getValue(pk);
        long endTime = System.nanoTime();
        Long startTime = this.timeLocal.get();
        if (startTime != null) {
            long timeUsed = endTime - startTime;
            if (stats != null) {
                stats.onFinally(timeUsed);
            }
        }
    }
}

