/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.PerfCounterModel;
import com.taobao.arthas.core.command.model.PerfCounterVO;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.List;

public class PerfCounterView
extends ResultView<PerfCounterModel> {
    @Override
    public void draw(CommandProcess process, PerfCounterModel result) {
        TableElement table;
        List<PerfCounterVO> perfCounters = result.getPerfCounters();
        boolean details = result.isDetails();
        if (details) {
            table = new TableElement(new int[]{3, 1, 1, 10}).leftCellPadding(1).rightCellPadding(1);
            table.row(true, new Element[]{Element.label((String)"Name").style(Decoration.bold.bold()), Element.label((String)"Variability").style(Decoration.bold.bold()), Element.label((String)"Units").style(Decoration.bold.bold()), Element.label((String)"Value").style(Decoration.bold.bold())});
        } else {
            table = new TableElement(new int[]{4, 6}).leftCellPadding(1).rightCellPadding(1);
            table.row(true, new Element[]{Element.label((String)"Name").style(Decoration.bold.bold()), Element.label((String)"Value").style(Decoration.bold.bold())});
        }
        for (PerfCounterVO counter : perfCounters) {
            if (details) {
                table.row(new String[]{counter.getName(), counter.getVariability(), counter.getUnits(), String.valueOf(counter.getValue())});
                continue;
            }
            table.row(new String[]{counter.getName(), String.valueOf(counter.getValue())});
        }
        process.write(RenderUtil.render((Element)table, (int)process.width()));
    }
}

