/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.alibaba.deps.org.objectweb.asm.Type;
import com.taobao.arthas.core.command.model.ClassDetailVO;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ClassVO;
import com.taobao.arthas.core.command.model.MethodVO;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassUtils {
    public static String getCodeSource(CodeSource cs) {
        if (null == cs || null == cs.getLocation() || null == cs.getLocation().getFile()) {
            return "";
        }
        return cs.getLocation().getFile();
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.getName().contains("$$Lambda$");
    }

    public static Element renderClassInfo(ClassDetailVO clazz) {
        return ClassUtils.renderClassInfo(clazz, false);
    }

    public static Element renderClassInfo(ClassDetailVO clazz, boolean isPrintField) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{Element.label((String)"class-info").style(Decoration.bold.bold()), Element.label((String)clazz.getClassInfo())}).row(new Element[]{Element.label((String)"code-source").style(Decoration.bold.bold()), Element.label((String)clazz.getCodeSource())}).row(new Element[]{Element.label((String)"name").style(Decoration.bold.bold()), Element.label((String)clazz.getName())}).row(new Element[]{Element.label((String)"isInterface").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isInterface()))}).row(new Element[]{Element.label((String)"isAnnotation").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isAnnotation()))}).row(new Element[]{Element.label((String)"isEnum").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isEnum()))}).row(new Element[]{Element.label((String)"isAnonymousClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isAnonymousClass()))}).row(new Element[]{Element.label((String)"isArray").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isArray()))}).row(new Element[]{Element.label((String)"isLocalClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isLocalClass()))}).row(new Element[]{Element.label((String)"isMemberClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isMemberClass()))}).row(new Element[]{Element.label((String)"isPrimitive").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isPrimitive()))}).row(new Element[]{Element.label((String)"isSynthetic").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isSynthetic()))}).row(new Element[]{Element.label((String)"simple-name").style(Decoration.bold.bold()), Element.label((String)clazz.getSimpleName())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)clazz.getModifier())}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)StringUtils.join(clazz.getAnnotations(), ","))}).row(new Element[]{Element.label((String)"interfaces").style(Decoration.bold.bold()), Element.label((String)StringUtils.join(clazz.getInterfaces(), ","))}).row(new Element[]{Element.label((String)"super-class").style(Decoration.bold.bold()), TypeRenderUtils.drawSuperClass(clazz)}).row(new Element[]{Element.label((String)"class-loader").style(Decoration.bold.bold()), TypeRenderUtils.drawClassLoader(clazz)}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)clazz.getClassLoaderHash())});
        if (isPrintField) {
            table.row(new Element[]{Element.label((String)"fields").style(Decoration.bold.bold()), TypeRenderUtils.drawField(clazz)});
        }
        return table;
    }

    public static ClassDetailVO createClassInfo(Class clazz, boolean withFields, Integer expand) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        ClassDetailVO classInfo = new ClassDetailVO();
        classInfo.setName(StringUtils.classname(clazz));
        classInfo.setClassInfo(StringUtils.classname(clazz));
        classInfo.setCodeSource(ClassUtils.getCodeSource(cs));
        classInfo.setInterface(clazz.isInterface());
        classInfo.setAnnotation(clazz.isAnnotation());
        classInfo.setEnum(clazz.isEnum());
        classInfo.setAnonymousClass(clazz.isAnonymousClass());
        classInfo.setArray(clazz.isArray());
        classInfo.setLocalClass(clazz.isLocalClass());
        classInfo.setMemberClass(clazz.isMemberClass());
        classInfo.setPrimitive(clazz.isPrimitive());
        classInfo.setSynthetic(clazz.isSynthetic());
        classInfo.setSimpleName(clazz.getSimpleName());
        classInfo.setModifier(StringUtils.modifier(clazz.getModifiers(), ','));
        classInfo.setAnnotations(TypeRenderUtils.getAnnotations(clazz));
        classInfo.setInterfaces(TypeRenderUtils.getInterfaces(clazz));
        classInfo.setSuperClass(TypeRenderUtils.getSuperClass(clazz));
        classInfo.setClassloader(TypeRenderUtils.getClassloader(clazz));
        classInfo.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
        if (withFields) {
            classInfo.setFields(TypeRenderUtils.getFields(clazz, expand));
        }
        return classInfo;
    }

    public static ClassVO createSimpleClassInfo(Class clazz) {
        ClassVO classInfo = new ClassVO();
        ClassUtils.fillSimpleClassVO(clazz, classInfo);
        return classInfo;
    }

    public static void fillSimpleClassVO(Class clazz, ClassVO classInfo) {
        classInfo.setName(StringUtils.classname(clazz));
        classInfo.setClassloader(TypeRenderUtils.getClassloader(clazz));
        classInfo.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
    }

    public static MethodVO createMethodInfo(Method method, Class clazz, boolean detail) {
        MethodVO methodVO = new MethodVO();
        methodVO.setDeclaringClass(clazz.getName());
        methodVO.setMethodName(method.getName());
        methodVO.setDescriptor(Type.getMethodDescriptor((Method)method));
        methodVO.setConstructor(false);
        if (detail) {
            methodVO.setModifier(StringUtils.modifier(method.getModifiers(), ','));
            methodVO.setAnnotations(TypeRenderUtils.getAnnotations(method.getDeclaredAnnotations()));
            methodVO.setParameters(ClassUtils.getClassNameList(method.getParameterTypes()));
            methodVO.setReturnType(StringUtils.classname(method.getReturnType()));
            methodVO.setExceptions(ClassUtils.getClassNameList(method.getExceptionTypes()));
            methodVO.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
        }
        return methodVO;
    }

    public static MethodVO createMethodInfo(Constructor constructor, Class clazz, boolean detail) {
        MethodVO methodVO = new MethodVO();
        methodVO.setDeclaringClass(clazz.getName());
        methodVO.setDescriptor(Type.getConstructorDescriptor((Constructor)constructor));
        methodVO.setMethodName("<init>");
        methodVO.setConstructor(true);
        if (detail) {
            methodVO.setModifier(StringUtils.modifier(constructor.getModifiers(), ','));
            methodVO.setAnnotations(TypeRenderUtils.getAnnotations(constructor.getDeclaredAnnotations()));
            methodVO.setParameters(ClassUtils.getClassNameList(constructor.getParameterTypes()));
            methodVO.setExceptions(ClassUtils.getClassNameList(constructor.getExceptionTypes()));
            methodVO.setClassLoaderHash(StringUtils.classLoaderHash(clazz));
        }
        return methodVO;
    }

    public static Element renderMethod(MethodVO method) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{Element.label((String)"declaring-class").style(Decoration.bold.bold()), Element.label((String)method.getDeclaringClass())}).row(new Element[]{Element.label((String)"method-name").style(Decoration.bold.bold()), Element.label((String)method.getMethodName()).style(Decoration.bold.bold())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)method.getModifier())}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(method.getAnnotations()))}).row(new Element[]{Element.label((String)"parameters").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawParameters(method.getParameters()))}).row(new Element[]{Element.label((String)"return").style(Decoration.bold.bold()), Element.label((String)method.getReturnType())}).row(new Element[]{Element.label((String)"exceptions").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawExceptions(method.getExceptions()))}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)method.getClassLoaderHash())});
        return table;
    }

    public static Element renderConstructor(MethodVO constructor) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{Element.label((String)"declaring-class").style(Decoration.bold.bold()), Element.label((String)constructor.getDeclaringClass())}).row(new Element[]{Element.label((String)"constructor-name").style(Decoration.bold.bold()), Element.label((String)"<init>").style(Decoration.bold.bold())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)constructor.getModifier())}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(constructor.getAnnotations()))}).row(new Element[]{Element.label((String)"parameters").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawParameters(constructor.getParameters()))}).row(new Element[]{Element.label((String)"exceptions").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawExceptions(constructor.getExceptions()))}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)constructor.getClassLoaderHash())});
        return table;
    }

    public static String[] getClassNameList(Class[] classes) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class anInterface : classes) {
            list.add(StringUtils.classname(anInterface));
        }
        return list.toArray(new String[0]);
    }

    public static List<ClassVO> createClassVOList(Collection<Class<?>> matchedClasses) {
        ArrayList<ClassVO> classVOs = new ArrayList<ClassVO>(matchedClasses.size());
        for (Class<?> aClass : matchedClasses) {
            ClassVO classVO = ClassUtils.createSimpleClassInfo(aClass);
            classVOs.add(classVO);
        }
        return classVOs;
    }

    public static ClassLoaderVO createClassLoaderVO(ClassLoader classLoader) {
        ClassLoaderVO classLoaderVO = new ClassLoaderVO();
        classLoaderVO.setHash(ClassUtils.classLoaderHash(classLoader));
        classLoaderVO.setName(classLoader == null ? "BootstrapClassLoader" : classLoader.toString());
        ClassLoader parent = classLoader == null ? null : classLoader.getParent();
        classLoaderVO.setParent(parent == null ? null : parent.toString());
        return classLoaderVO;
    }

    public static List<ClassLoaderVO> createClassLoaderVOList(Collection<ClassLoader> classLoaders) {
        ArrayList<ClassLoaderVO> classLoaderVOList = new ArrayList<ClassLoaderVO>();
        for (ClassLoader classLoader : classLoaders) {
            classLoaderVOList.add(ClassUtils.createClassLoaderVO(classLoader));
        }
        return classLoaderVOList;
    }

    public static String classLoaderHash(Class<?> clazz) {
        if (clazz == null || clazz.getClassLoader() == null) {
            return "null";
        }
        return Integer.toHexString(clazz.getClassLoader().hashCode());
    }

    public static String classLoaderHash(ClassLoader classLoader) {
        if (classLoader == null) {
            return "null";
        }
        return Integer.toHexString(classLoader.hashCode());
    }

    public static Element renderMatchedClasses(Collection<ClassVO> matchedClasses) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{new LabelElement("NAME").style(Decoration.bold.bold()), new LabelElement("HASHCODE").style(Decoration.bold.bold()), new LabelElement("CLASSLOADER").style(Decoration.bold.bold())});
        for (ClassVO c : matchedClasses) {
            table.row(new Element[]{Element.label((String)c.getName()), Element.label((String)c.getClassLoaderHash()).style(Decoration.bold.fg(Color.red)), TypeRenderUtils.drawClassLoader(c)});
        }
        return table;
    }
}

