/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqConsumerCollector;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;

public class AsyncPullCallbackOnSuccessInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Map context;
            if (RocketMqConsumerCollector.INSTANCE.isEnable() && (context = (Map)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"context")) != null) {
                PullResult pullResult = (PullResult)args[0];
                boolean isFoundFailed = false;
                SpanEvent spanEvent = (SpanEvent)context.get("spanEvent");
                int msgCount = 0;
                int msgBytes = 0;
                if (pullResult != null) {
                    PullStatus pullStatus = pullResult.getPullStatus();
                    if (!PullStatus.FOUND.equals((Object)pullStatus)) {
                        isFoundFailed = true;
                    }
                    List msgList = pullResult.getMsgFoundList();
                    msgCount = RocketMqUtils.getMsgCount(msgList);
                    msgBytes = RocketMqUtils.getMsgBytes(msgList);
                    if (spanEvent != null) {
                        spanEvent.addTag("status", pullStatus.name());
                        spanEvent.addTag("msgCount", String.valueOf(msgCount));
                        spanEvent.addTag("msgBytes", String.valueOf(msgBytes));
                    }
                }
                RocketMqConsumerCollector.onPullFinallyAsync(context, msgCount, msgBytes, isFoundFailed);
                if (spanEvent != null) {
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception rocketMqPullException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPullException);
        }
    }
}

