/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.producer.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqProducerCollector;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;

public class SendMessageInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                DefaultMQProducerImpl producerImp = (DefaultMQProducerImpl)args[11];
                DefaultMQProducer producer = (DefaultMQProducer)((AttributeAccess)producerImp).getLopsFileds()[0];
                String clientId = RocketMqUtils.getClientId(producerImp);
                String group = producer.getProducerGroup();
                String brokerAddr = ((String)args[0]).replace("/", "");
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (spanEvent != null) {
                    spanEvent.addTag("brokerAddr", brokerAddr);
                }
                RocketMqProducerCollector.onInnerSendStart(clientId, group, brokerAddr);
            }
        }
        catch (Exception sendMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)sendMessageException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception sendMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)sendMessageException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                SendStatus sendStatus;
                boolean isSendFailed = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    isSendFailed = true;
                }
                Message msg = (Message)args[2];
                int msgCount = RocketMqUtils.getMessageCount(msg);
                int msgBytes = msg.getBody().length;
                SendResult sendResult = (SendResult)result;
                if (result != null && !SendStatus.SEND_OK.equals((Object)(sendStatus = sendResult.getSendStatus()))) {
                    isSendFailed = true;
                }
                if (isSendFailed) {
                    RocketMqProducerCollector.onInnerSendError(TraceCollector.getTraceId());
                }
                RocketMqProducerCollector.onInnerSendFinally(msgCount, msgBytes, isSendFailed);
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception sendMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)sendMessageException);
        }
    }
}

