/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.jdbc;

import com.huawei.dws.pbq.api.model.RowType;
import com.huawei.dws.pbq.api.model.StatementResult;
import com.huawei.dws.pbq.api.model.StatementResultSet;
import com.huawei.gauss200.jdbc.Driver;
import com.huawei.gauss200.jdbc.core.types.PGClob;
import com.huawei.gauss200.jdbc.jdbc.BooleanTypeUtil;
import com.huawei.gauss200.jdbc.jdbc.PayByQueryConnection;
import com.huawei.gauss200.jdbc.jdbc.PbqResultSetMetaData;
import com.huawei.gauss200.jdbc.jdbc.PbqStatement;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import com.huawei.gauss200.jdbc.util.internal.Nullness;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PbqResultSet
implements ResultSet {
    private List<List<String>> rows;
    private List<String> currentRow;
    private PbqResultSetMetaData metadata;
    private StatementResultSet statementResultSet;
    private StatementResult statementResult;
    private PayByQueryConnection connection;
    private Statement statement;
    private int rowIndex = -1;
    private long numRows;
    private long pageNo;
    private long pageCount;
    private int rowOffset;
    protected boolean wasNullFlag = false;
    private Map<String, Integer> columnNameIndexMap;
    private int maxFieldSize;

    public PbqResultSet(StatementResult statementResult, PbqStatement statement, int maxFieldSize) throws SQLException {
        this.statementResult = statementResult;
        this.refreshPage(statementResult);
        this.statement = statement;
        this.connection = (PayByQueryConnection)statement.getConnection();
        this.maxFieldSize = maxFieldSize;
    }

    private void refreshPage(StatementResult statementResult) {
        this.statementResultSet = statementResult.getResultSet();
        this.rows = this.statementResultSet.getRows();
        this.numRows = statementResult.getNumRows();
        this.pageNo = statementResult.getPageNo();
        this.pageCount = statementResult.getPageCount();
    }

    @Override
    public boolean next() throws SQLException {
        Nullness.castNonNull(this.rows, "rows");
        if (this.rowIndex + 1 >= this.rows.size()) {
            if (this.pageCount > this.pageNo) {
                this.rowOffset += this.rows.size();
                List<StatementResult> results = this.connection.getExecutor().getStatementResult(this.statementResult);
                if (results != null && !results.isEmpty()) {
                    this.statementResult = results.get(0);
                    this.refreshPage(this.statementResult);
                    if (this.rows == null || this.rows.isEmpty()) {
                        return false;
                    }
                    this.rowIndex = 0;
                    this.currentRow = this.rows.get(this.rowIndex);
                    return true;
                }
            }
            return false;
        }
        ++this.rowIndex;
        this.currentRow = this.rows.get(this.rowIndex);
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.rows = null;
        this.currentRow = null;
        ((PbqStatement)this.statement).checkCompletion();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String str = this.currentRow.get(columnIndex - 1);
        if (str == null) {
            this.wasNullFlag = true;
            return null;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (this.maxFieldSize == 0 || bytes.length <= this.maxFieldSize) {
            return str;
        }
        byte[] newBytes = new byte[this.maxFieldSize];
        System.arraycopy(bytes, 0, newBytes, 0, this.maxFieldSize);
        return new String(newBytes);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return BooleanTypeUtil.castToBoolean(stringVal);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return Byte.parseByte(stringVal);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return Short.parseShort(stringVal);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return Integer.parseInt(stringVal);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return Long.parseLong(stringVal);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return Float.parseFloat(stringVal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return Double.parseDouble(stringVal);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return new BigDecimal(stringVal).setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        return string.getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        try {
            String stringValue = Nullness.castNonNull(this.getString(columnIndex));
            return new ByteArrayInputStream(stringValue.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        try {
            String stringValue = Nullness.castNonNull(this.getString(columnIndex));
            return new ByteArrayInputStream(stringValue.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "UTF-8"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        byte[] b = this.getBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    private int findColumnIndex(String columnName) {
        Integer index;
        if (this.columnNameIndexMap == null) {
            this.columnNameIndexMap = this.createColumnNameIndexMap(this.connection.isColumnSanitiserDisabled());
        }
        if ((index = this.columnNameIndexMap.get(columnName)) != null) {
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toLowerCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toUpperCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        return 0;
    }

    public Map<String, Integer> createColumnNameIndexMap(boolean isSanitiserDisabled) {
        List rowType = this.statementResultSet.getColumns();
        HashMap<String, Integer> columnNameIndexMap = new HashMap<String, Integer>(rowType.size());
        for (int i = rowType.size() - 1; i >= 0; --i) {
            String columnLabel = ((RowType)rowType.get(i)).getName();
            if (isSanitiserDisabled) {
                columnNameIndexMap.put(columnLabel, i + 1);
                continue;
            }
            columnNameIndexMap.put(columnLabel.toLowerCase(Locale.US), i + 1);
        }
        return columnNameIndexMap;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getByte(columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getShort(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getLong(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getFloat(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getBytes(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getDate(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new PbqResultSetMetaData(this.connection, this.statementResultSet.getColumns());
        }
        return this.metadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int col = this.findColumnIndex(columnLabel);
        if (col == 0) {
            throw new PSQLException(GT.tr("The column name {0} was not found in this ResultSet.", columnLabel), PSQLState.UNDEFINED_COLUMN);
        }
        return col;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value == null) {
            return null;
        }
        return new CharArrayReader(value.toCharArray());
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String stringVal = this.getString(columnIndex);
        return new BigDecimal(stringVal);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumnIndex(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.rowOffset + this.rowIndex < 0 && !Nullness.castNonNull(this.rows, "rows").isEmpty();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        Nullness.castNonNull(this.rows, "rows");
        int rows_size = this.rows.size();
        if (this.rowOffset + rows_size == 0) {
            return false;
        }
        return this.rowIndex >= rows_size;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        int rows_size = this.rows.size();
        if (this.rowOffset + rows_size == 0) {
            return false;
        }
        return this.rowOffset + this.rowIndex == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        Nullness.castNonNull(this.rows, "rows");
        int rows_size = this.rows.size();
        if (rows_size == 0) {
            return false;
        }
        if (this.rowIndex != rows_size - 1) {
            return false;
        }
        if (this.numRows > 0L && (long)(this.rowOffset + this.rowIndex) == this.numRows) {
            return true;
        }
        return this.rows.size() == 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        Nullness.castNonNull(this.rows, "rows");
        if (!this.rows.isEmpty()) {
            this.rowIndex = -1;
        }
        this.currentRow = null;
    }

    @Override
    public void afterLast() throws SQLException {
        Nullness.castNonNull(this.rows, "rows");
        int rows_size = this.rows.size();
        if (rows_size > 0) {
            this.rowIndex = rows_size;
        }
        this.currentRow = null;
    }

    @Override
    public boolean first() throws SQLException {
        Nullness.castNonNull(this.rows, "rows");
        int rows_size = this.rows.size();
        if (rows_size == 0) {
            return false;
        }
        this.rowIndex = 0;
        this.currentRow = this.rows.get(this.rowIndex);
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        Nullness.castNonNull(this.rows, "rows");
        int rows_size = this.rows.size();
        if (rows_size == 0) {
            return false;
        }
        this.rowIndex = rows_size - 1;
        this.currentRow = this.rows.get(this.rowIndex);
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowOffset + this.rowIndex + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        int internalIndex;
        if (row == 0) {
            this.beforeFirst();
            return false;
        }
        int rows_size = this.rows.size();
        if (row < 0) {
            if (row < -rows_size) {
                this.beforeFirst();
                return false;
            }
            internalIndex = rows_size + row;
        } else {
            if (row > rows_size) {
                this.afterLast();
                return false;
            }
            internalIndex = row - 1;
        }
        this.currentRow = this.rows.get(internalIndex);
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        Nullness.castNonNull(this.rows, "rows");
        if (this.rowIndex - 1 < 0) {
            this.rowIndex = -1;
            this.currentRow = null;
            return false;
        }
        ++this.rowIndex;
        this.currentRow = this.rows.get(this.rowIndex);
        return true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setFetchSize(int)");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    protected void checkClosed() throws SQLException {
        if (this.rows == null) {
            throw new PSQLException(GT.tr("This ResultSet is closed.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNull(int)");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBoolean(int, boolean)");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateByte(int, byte)");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateShort(int, short)");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateInt(int, int)");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateLong(int, long)");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateFloat(int, float)");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateDouble(int, double)");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBigDecimal(int, BigDecimal)");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateString(int, String)");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBytes(int, byte[])");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateDate(int, Date)");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateTime(int, Time)");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateTimestamp(int, Timestamp)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream, int)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream, int)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharacterStream(int, Reader, int)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharacterStream(int, Object, int)");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateObject(int, Object)");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNull(String)");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBoolean(String, boolean)");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateByte(String, byte)");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateShort(String, short)");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateInt(String, int)");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateLong(String, long)");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateFloat(String, float)");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateDouble(String, double)");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBigDecimal(String, BigDecimal)");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateString(String, String)");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBytes(String, byte[])");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateDate(String, Date)");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateTime(String, Time)");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateTimestamp(String, Timestamp)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(String, InputStream, int)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(String, InputStream, int)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharacterStream(String, Reader, int)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharacterStream(String, Object, int)");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateObject(String, Object)");
    }

    @Override
    public void insertRow() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "insertRow()");
    }

    @Override
    public void updateRow() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRow()");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "deleteRow()");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "refreshRow()");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "cancelRowUpdates()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "moveToCurrentRow()");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(int,Map)");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        PGClob clob = new PGClob();
        clob.setString(1L, str);
        return clob;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getArray(int)");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Map)");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(String)");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(String)");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getClob(columnIndex);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getArray(String)");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.connection.getTimestampUtils().toDate(cal, Nullness.castNonNull(this.getString(columnIndex)));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.connection.getTimestampUtils().toDate(cal, Nullness.castNonNull(this.getString(columnLabel)));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String string = this.getString(columnIndex);
        return this.connection.getTimestampUtils().toTime(cal, string);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        String string = this.getString(columnLabel);
        return this.connection.getTimestampUtils().toTime(cal, string);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String string = this.getString(columnIndex);
        long time = this.connection.getTimestampUtils().toTimestamp(cal, string).getTime();
        return new Timestamp(time);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumnIndex(columnLabel);
        return this.getTimestamp(columnIndex, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRef(int, Ref)");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRef(String, Ref)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(String, Blob)");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(String, Blob)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Clob)");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(String, Clob)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Array)");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateArray(String, Array)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(String)");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRowId(int, RowId)");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRowId(String, RowId)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getHoldability()");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rows == null;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNString(int, String)");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNString(String, String)");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNString(int, NClob)");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNString(String, NClob)");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(String)");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(int)");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String)");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(int, SQLXML)");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String, SQLXML)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumnIndex(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(String)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, long)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(String, Reader, long)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream, long)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream, long)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, Reader, long)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(String, InputStream, long)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(String, InputStream, long)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharacterStream(String, Reader, long)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream, long)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(String, InputStream, long)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader, long)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(String, Reader, long)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader, long)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(String, Reader, long)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(String, Reader)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharacterStream(int, Reader)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(String, InputStream)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(String, InputStream)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharacterStream(String, Reader)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(String, InputStream)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(String, Reader)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(String, Reader)");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(int, Class)");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Class)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

