/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.lang;

import com.taobao.text.Color;
import com.taobao.text.Style;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fife.ui.rsyntaxtextarea.TokenTypes;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HighLightTheme {
    Map<Integer, Style> styleMap = new HashMap<Integer, Style>();
    static Map<String, Integer> tokenTypeMap;
    static final String defaulConfigPath = "com/taobao/text/ui/themes/default.xml";
    private static volatile HighLightTheme defaultTheme;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HighLightTheme load(URL url) throws Exception {
        InputStream openStream = null;
        try {
            openStream = url.openStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(openStream);
            NodeList elements = document.getElementsByTagName("style");
            HighLightTheme theme = new HighLightTheme();
            for (int i = 0; i < elements.getLength(); ++i) {
                Node bold;
                Node bg;
                Node item = elements.item(i);
                NamedNodeMap attributes = item.getAttributes();
                Node token = attributes.getNamedItem("token");
                String tokenValue = token.getNodeValue();
                Integer tokenType = tokenTypeMap.get(tokenValue);
                if (tokenType == null) continue;
                Color fgColor = null;
                Color bgColor = null;
                Boolean boldValue = null;
                Node fg = attributes.getNamedItem("fg");
                if (fg != null) {
                    fgColor = Color.valueOf(fg.getNodeValue());
                }
                if ((bg = attributes.getNamedItem("bg")) != null) {
                    bgColor = Color.valueOf(bg.getNodeValue());
                }
                if ((bold = attributes.getNamedItem("bold")) != null) {
                    boldValue = Boolean.parseBoolean(bold.getNodeValue());
                }
                theme.setStyle(tokenType, Style.Composite.style(boldValue, null, null, fgColor, bgColor));
            }
            HighLightTheme highLightTheme = theme;
            return highLightTheme;
        }
        finally {
            if (openStream != null) {
                openStream.close();
            }
        }
    }

    public static HighLightTheme defaultTheme() {
        if (defaultTheme == null) {
            URL resource = HighLightTheme.class.getClassLoader().getResource(defaulConfigPath);
            try {
                defaultTheme = HighLightTheme.load(resource);
            }
            catch (Exception e) {
                throw new RuntimeException("load text.ui theme error!", e);
            }
        }
        return defaultTheme;
    }

    public Style getStyle(int tokenType) {
        Style style = this.styleMap.get(tokenType);
        if (style != null) {
            return style;
        }
        return Style.style();
    }

    public void setStyle(int tokenType, Style style) {
        this.styleMap.put(tokenType, style);
    }

    static {
        Field[] declaredFields;
        defaultTheme = null;
        tokenTypeMap = new HashMap<String, Integer>();
        for (Field field : declaredFields = TokenTypes.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                tokenTypeMap.put(field.getName(), field.getInt(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

