/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.url.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlAggregatorEnum;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlExceptionStats;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UrlExceptionAggregator
extends MultiPrimaryKeyAggregator<UrlExceptionStats> {
    private static final Logger LOGGER = LogFactory.getLogger();
    static String tag_url = "url";
    static String tag_method = "method";
    static String tag_exception = "exception";

    public String getName() {
        return UrlAggregatorEnum.exception.name();
    }

    protected int primaryKeyLength() {
        return 3;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(tag_url, tag_method, tag_exception);
    }

    public List<MonitorDataRow> harvest() {
        List result = super.harvest();
        if (UrlStatsCollector.getAutoNormalize()) {
            this.valueStats = new ConcurrentHashMap(100);
        }
        return result;
    }

    public void onFinally(Boolean hasException, String exceptionType) {
        String method;
        if (!this.isEnable) {
            return;
        }
        Map map = this.getContextMap();
        if (!hasException.booleanValue() || exceptionType == null) {
            map.clear();
            return;
        }
        String url = (String)this.getContextValue(map, tag_url);
        PrimaryKey pk = new PrimaryKey(new String[]{url, method = (String)this.getContextValue(map, tag_method), exceptionType});
        UrlExceptionStats stat = (UrlExceptionStats)this.getValue(pk);
        if (stat != null) {
            stat.getExceptionCount().incrementAndGet();
        }
        map.clear();
    }

    public void onStart(String url, String method) {
        if (!this.isEnable) {
            return;
        }
        Map map = this.getContextMap();
        map.put(tag_url, url);
        map.put(tag_method, method);
    }

    protected Class<UrlExceptionStats> getValueType() {
        return UrlExceptionStats.class;
    }
}

