/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.collector.method;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.api.InstrumentationManager;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.collector.method.JavaMethodAggregator;
import com.lubanops.apm.bootstrap.plugin.collector.method.MethodPattern;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class JavaMethodCollector
extends Collector {
    public static final JavaMethodCollector INSTANCE = new JavaMethodCollector();
    public static final JavaMethodAggregator JAVA_METHOD_AGGREGATOR = new JavaMethodAggregator();
    private static ThreadLocal<ArrayDeque<Long>> arrayDeque = new ThreadLocal();
    private static Map<String, Boolean> needCountMap = new ConcurrentHashMap<String, Boolean>();
    private static boolean bodyDetail = false;
    private static int bodyDetailLength = 8192;
    private List<MethodPattern> methodPatterns = new ArrayList<MethodPattern>();

    public static JavaMethodCollector getInstance() {
        return INSTANCE;
    }

    public static void setNeedCount(String className, Boolean needCount) {
        needCountMap.put(className, needCount);
    }

    public static boolean needCount(String className) {
        Boolean result = needCountMap.get(className);
        if (result == null) {
            return false;
        }
        return result;
    }

    public static void onStart(String className, String methodName) {
        ArrayDeque<Long> ad = arrayDeque.get();
        if (ad == null) {
            ad = new ArrayDeque();
            arrayDeque.set(ad);
        }
        long startTime = System.nanoTime();
        ad.offerLast(startTime);
        JAVA_METHOD_AGGREGATOR.onStart(className, methodName);
    }

    public static void onThrowable(String className, String methodName, Throwable t) {
        JAVA_METHOD_AGGREGATOR.onThrowable(className, methodName, t);
    }

    public static void onFinally(String className, String methodName) {
        Long startTime;
        ArrayDeque<Long> ad = arrayDeque.get();
        if (ad != null && (startTime = ad.pollLast()) != null) {
            long endTime = System.nanoTime();
            long timeUsed = endTime - startTime;
            JAVA_METHOD_AGGREGATOR.onFinally(className, methodName, timeUsed);
        }
    }

    public static boolean isBodyDetail() {
        return bodyDetail;
    }

    public static int getBodyDetailLength() {
        return bodyDetailLength;
    }

    public void parseParameter(Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        List<MethodPattern> oldMethodPatterns = this.methodPatterns;
        String methodPatternsStr = parameters.get("methodPatterns");
        this.methodPatterns = StringUtils.isBlank((String)methodPatternsStr) ? new ArrayList<MethodPattern>() : APIService.getJsonApi().parseList(methodPatternsStr, MethodPattern.class);
        Boolean bodyDetail = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"bodyDetail", Boolean.class);
        JavaMethodCollector.bodyDetail = bodyDetail != null ? bodyDetail : false;
        Integer bodyDetailLength = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"bodyDetailLength", Integer.class);
        JavaMethodCollector.bodyDetailLength = bodyDetailLength != null ? bodyDetailLength : 8192;
        if (InstrumentationManager.inst != null) {
            this.retransformClasses(oldMethodPatterns, this.methodPatterns);
        }
    }

    public String getCollectorName() {
        return "JavaMethod";
    }

    private void retransformClasses(List<MethodPattern> oldJavaMethodPattern, List<MethodPattern> newJavaMethodPattern) {
        try {
            Class[] loadedClasses;
            String className;
            int i;
            HashSet<String> classPatternsSet = new HashSet<String>();
            for (i = 0; i < newJavaMethodPattern.size(); ++i) {
                className = newJavaMethodPattern.get(i).getClassName();
                classPatternsSet.add(className);
            }
            for (i = 0; i < oldJavaMethodPattern.size(); ++i) {
                className = oldJavaMethodPattern.get(i).getClassName();
                classPatternsSet.add(className);
            }
            if (classPatternsSet.size() == 0) {
                return;
            }
            block4: for (Class loadedClass : loadedClasses = InstrumentationManager.inst.getAllLoadedClasses()) {
                String className2 = loadedClass.getName();
                if (className2.startsWith("com/lubanops/apm/bootstrap") || className2.startsWith("com/lubanops/apm/premain") || className2.startsWith("com/lubanops/apm/transformer")) continue;
                for (String classPattern : classPatternsSet) {
                    if (!Pattern.matches(classPattern, className2)) continue;
                    needCountMap.put(className2, false);
                    InstrumentationManager.inst.retransformClasses(loadedClass);
                    continue block4;
                }
            }
        }
        catch (Throwable e) {
            LogFactory.getLogger().log(Level.SEVERE, "javamethod retranform error ", e);
        }
    }

    public List<MethodPattern> getMethodPatterns() {
        return this.methodPatterns;
    }

    public void setMethodPatterns(List<MethodPattern> methodPatterns) {
        this.methodPatterns = methodPatterns;
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)JAVA_METHOD_AGGREGATOR);
        INSTANCE.register();
    }
}

