/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.method.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.collector.method.JavaMethodCollector;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;

public class JavaMethodInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (JavaMethodCollector.INSTANCE.isEnable()) {
                SpanEvent spanevent = TraceCollector.onStart((String)className, (String)methodName, (String)"JavaMethod");
                if (AgentConfigManager.isCollectMethodBody() && spanevent != null) {
                    for (int i = 0; i < args.length; ++i) {
                        spanevent.addTag("args[" + i + "]", String.valueOf(args[i]), AgentConfigManager.getCollectBodyLength());
                    }
                }
                if (JavaMethodCollector.needCount(className)) {
                    JavaMethodCollector.onStart(className, methodName);
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "JavaMethodInterceptor onStart", (Throwable)e);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (JavaMethodCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                if (JavaMethodCollector.needCount(className)) {
                    JavaMethodCollector.onThrowable(className, methodName, e);
                }
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "JavaMethodInterceptor onError", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JavaMethodCollector.INSTANCE.isEnable()) {
                SpanEvent spanevent = TraceCollector.onFinally();
                if (AgentConfigManager.isCollectMethodBody() && spanevent != null && result != null) {
                    spanevent.addTag("result", String.valueOf(result), AgentConfigManager.getCollectBodyLength());
                }
                if (JavaMethodCollector.needCount(className)) {
                    JavaMethodCollector.onFinally(className, methodName);
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "JavaMethodInterceptor onFinally", (Throwable)e);
        }
    }
}

