/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc;

import com.huawei.gaussdb.jdbc.Driver;
import com.huawei.gaussdb.jdbc.jdbc.PgConnection;
import com.huawei.gaussdb.jdbc.jdbc.ResourceLock;
import com.huawei.gaussdb.jdbc.util.GT;
import java.io.Closeable;
import java.io.IOException;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

class PgConnectionFinalizeAction
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(PgConnection.class.getName());
    private final ResourceLock lock;
    private Throwable openStackTrace;
    private final Closeable queryExecutorCloseAction;
    private Timer cancelTimer;

    PgConnectionFinalizeAction(ResourceLock lock, Throwable openStackTrace, Closeable queryExecutorCloseAction) {
        this.lock = lock;
        this.openStackTrace = openStackTrace;
        this.queryExecutorCloseAction = queryExecutorCloseAction;
    }

    public Timer getTimer() {
        try (ResourceLock ignore = this.lock.obtain();){
            Timer timer = this.cancelTimer;
            if (timer == null) {
                this.cancelTimer = timer = Driver.getSharedTimer().getTimer();
            }
            Timer timer2 = timer;
            return timer2;
        }
    }

    public void releaseTimer() {
        try (ResourceLock ignore = this.lock.obtain();){
            if (this.cancelTimer != null) {
                this.cancelTimer = null;
                Driver.getSharedTimer().releaseTimer();
            }
        }
    }

    public void purgeTimerTasks() {
        try (ResourceLock ignore = this.lock.obtain();){
            Timer timer = this.cancelTimer;
            if (timer != null) {
                timer.purge();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.openStackTrace != null) {
            LOGGER.log(Level.WARNING, GT.tr("Finalizing a Connection that was never closed:", new Object[0]).replaceAll("[\r\n]", ""), this.openStackTrace);
        }
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.openStackTrace = null;
        this.releaseTimer();
        this.queryExecutorCloseAction.close();
    }

    public String toString() {
        return "PgConnectionFinalizeAction{lock=" + this.lock + ", openStackTrace=" + this.openStackTrace + ", queryExecutorCloseAction=" + this.queryExecutorCloseAction + ", cancelTimer=" + this.cancelTimer + '}';
    }
}

