/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.handler;

import com.huawei.gaussdb.jdbc.jdbc.handler.TypeInfoHandler;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MTypeInfoHandler
implements TypeInfoHandler {
    private ConcurrentHashMap<Integer, Integer> precisionToInteger = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Integer> oidToInteger = new ConcurrentHashMap();

    public MTypeInfoHandler() {
        this.precisionToInteger.put(5545, 3);
        this.precisionToInteger.put(21, 5);
        this.precisionToInteger.put(9877, 7);
        this.precisionToInteger.put(26, 10);
        this.precisionToInteger.put(23, 10);
        this.precisionToInteger.put(20, 19);
        this.precisionToInteger.put(349, 3);
        this.precisionToInteger.put(352, 5);
        this.precisionToInteger.put(9621, 8);
        this.precisionToInteger.put(353, 10);
        this.precisionToInteger.put(388, 20);
        this.precisionToInteger.put(9879, 255);
        this.precisionToInteger.put(88, 65535);
        this.precisionToInteger.put(9977, 0xFFFFFF);
        this.precisionToInteger.put(9975, Integer.MAX_VALUE);
        this.precisionToInteger.put(1038, 4);
        this.precisionToInteger.put(18, 1);
        this.precisionToInteger.put(16, 1);
        this.precisionToInteger.put(9880, 255);
        this.precisionToInteger.put(9878, 0xFFFFFF);
        this.precisionToInteger.put(9976, Integer.MAX_VALUE);
        this.oidToInteger.put(5545, 3);
        this.oidToInteger.put(21, 5);
        this.oidToInteger.put(9877, 7);
        this.oidToInteger.put(23, 10);
        this.oidToInteger.put(26, 10);
        this.oidToInteger.put(20, 19);
        this.oidToInteger.put(349, 3);
        this.oidToInteger.put(352, 5);
        this.oidToInteger.put(9621, 8);
        this.oidToInteger.put(353, 10);
        this.oidToInteger.put(388, 20);
        this.oidToInteger.put(9879, 255);
        this.oidToInteger.put(88, 65535);
        this.oidToInteger.put(9977, 0xFFFFFF);
        this.oidToInteger.put(9975, Integer.MAX_VALUE);
        this.oidToInteger.put(1038, 4);
        this.oidToInteger.put(18, 1);
        this.oidToInteger.put(16, 1);
        this.oidToInteger.put(1082, 10);
        this.oidToInteger.put(1186, 49);
        this.oidToInteger.put(9880, 255);
        this.oidToInteger.put(9878, 0xFFFFFF);
        this.oidToInteger.put(9976, Integer.MAX_VALUE);
    }

    @Override
    public boolean isSigned(int oid) {
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: 
            case 5545: 
            case 9877: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 349: 
            case 352: 
            case 353: 
            case 388: 
            case 700: 
            case 701: 
            case 1038: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1560: 
            case 5545: 
            case 9621: 
            case 9876: 
            case 9877: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getScale(int oid, int mod) {
        switch (oid) {
            case 700: 
            case 701: 
            case 1700: {
                if (mod == -1) {
                    return 0;
                }
                return (mod - 4 & 0x7C0000) >> 18;
            }
            case 1186: {
                if (mod == -1) {
                    return 6;
                }
                return mod & 0xFFFF;
            }
            case 1184: 
            case 1266: {
                if (mod == -1) {
                    return 6;
                }
                return mod;
            }
        }
        return 0;
    }

    @Override
    public int getPrecision(int oid, int mod, int defaultLength) {
        if (this.precisionToInteger.containsKey(oid)) {
            return this.precisionToInteger.get(oid);
        }
        switch (oid) {
            case 700: 
            case 701: 
            case 1700: {
                if (mod == -1) {
                    return 0;
                }
                return (mod - 4 & 0x7F800000) >> 23;
            }
            case 1042: 
            case 1043: 
            case 3969: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod - 4;
            }
            case 1562: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod;
            }
            case 1560: {
                return mod;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 9003: 
            case 9876: {
                return this.getDisplaySize(oid, mod, defaultLength);
            }
            case 25: 
            case 9881: 
            case 9974: {
                return mod - 4;
            }
        }
        return defaultLength;
    }

    @Override
    public int getDisplaySize(int oid, int mod, int defaultLength) {
        if (this.oidToInteger.containsKey(oid)) {
            return this.oidToInteger.get(oid);
        }
        switch (oid) {
            case 1114: 
            case 9876: {
                if (mod == 0) {
                    return 19;
                }
                return 20 + mod;
            }
            case 1083: {
                if (mod == 0) {
                    return 10;
                }
                return 11 + mod;
            }
            case 1042: 
            case 1043: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod - 4;
            }
            case 700: 
            case 701: 
            case 1700: {
                return this.getPrecision(oid, mod, defaultLength);
            }
            case 1560: {
                return mod;
            }
            case 1562: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod;
            }
            case 25: 
            case 9881: 
            case 9974: {
                return mod - 4;
            }
        }
        return defaultLength;
    }

    public String toString() {
        return "MTypeInfoHandler{precisionToInteger=" + this.precisionToInteger + ", oidToInteger=" + this.oidToInteger + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MTypeInfoHandler)) {
            return false;
        }
        MTypeInfoHandler that = (MTypeInfoHandler)o;
        return Objects.equals(this.precisionToInteger, that.precisionToInteger) && Objects.equals(this.oidToInteger, that.oidToInteger);
    }

    public int hashCode() {
        return Objects.hash(this.precisionToInteger, this.oidToInteger);
    }
}

